/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.autoscaling.model.*;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

/**
 * BatchDeleteScheduledActionResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class BatchDeleteScheduledActionResponseUnmarshaller implements
        Unmarshaller<BatchDeleteScheduledActionResponse, StaxUnmarshallerContext> {

    public BatchDeleteScheduledActionResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        BatchDeleteScheduledActionResponse.Builder batchDeleteScheduledActionResponse = BatchDeleteScheduledActionResponse
                .builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 2;

        java.util.List<FailedScheduledUpdateGroupActionRequest> failedScheduledActions = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                batchDeleteScheduledActionResponse.failedScheduledActions(failedScheduledActions);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("FailedScheduledActions", targetDepth)) {
                    failedScheduledActions = new ArrayList<FailedScheduledUpdateGroupActionRequest>();
                    continue;
                }

                if (context.testExpression("FailedScheduledActions/member", targetDepth)) {
                    failedScheduledActions.add(FailedScheduledUpdateGroupActionRequestUnmarshaller.getInstance().unmarshall(
                            context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    batchDeleteScheduledActionResponse.failedScheduledActions(failedScheduledActions);
                    break;
                }
            }
        }
        return batchDeleteScheduledActionResponse.build();
    }

    private static final BatchDeleteScheduledActionResponseUnmarshaller INSTANCE = new BatchDeleteScheduledActionResponseUnmarshaller();

    public static BatchDeleteScheduledActionResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
