/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.autoscaling.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;

/**
 * BatchPutScheduledUpdateGroupActionRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class BatchPutScheduledUpdateGroupActionRequestMarshaller implements
        Marshaller<Request<BatchPutScheduledUpdateGroupActionRequest>, BatchPutScheduledUpdateGroupActionRequest> {

    public Request<BatchPutScheduledUpdateGroupActionRequest> marshall(
            BatchPutScheduledUpdateGroupActionRequest batchPutScheduledUpdateGroupActionRequest) {

        if (batchPutScheduledUpdateGroupActionRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<BatchPutScheduledUpdateGroupActionRequest> request = new DefaultRequest<BatchPutScheduledUpdateGroupActionRequest>(
                batchPutScheduledUpdateGroupActionRequest, "AutoScalingClient");
        request.addParameter("Action", "BatchPutScheduledUpdateGroupAction");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (batchPutScheduledUpdateGroupActionRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName",
                    StringConversion.fromString(batchPutScheduledUpdateGroupActionRequest.autoScalingGroupName()));
        }

        if (batchPutScheduledUpdateGroupActionRequest.scheduledUpdateGroupActions().isEmpty()
                && !(batchPutScheduledUpdateGroupActionRequest.scheduledUpdateGroupActions() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("ScheduledUpdateGroupActions", "");
        } else if (!batchPutScheduledUpdateGroupActionRequest.scheduledUpdateGroupActions().isEmpty()
                && !(batchPutScheduledUpdateGroupActionRequest.scheduledUpdateGroupActions() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<ScheduledUpdateGroupActionRequest> scheduledUpdateGroupActionsList = batchPutScheduledUpdateGroupActionRequest
                    .scheduledUpdateGroupActions();
            int scheduledUpdateGroupActionsListIndex = 1;

            for (ScheduledUpdateGroupActionRequest scheduledUpdateGroupActionsListValue : scheduledUpdateGroupActionsList) {

                if (scheduledUpdateGroupActionsListValue.scheduledActionName() != null) {
                    request.addParameter("ScheduledUpdateGroupActions.member." + scheduledUpdateGroupActionsListIndex
                            + ".ScheduledActionName",
                            StringConversion.fromString(scheduledUpdateGroupActionsListValue.scheduledActionName()));
                }

                if (scheduledUpdateGroupActionsListValue.startTime() != null) {
                    request.addParameter("ScheduledUpdateGroupActions.member." + scheduledUpdateGroupActionsListIndex
                            + ".StartTime", StringConversion.fromInstant(scheduledUpdateGroupActionsListValue.startTime()));
                }

                if (scheduledUpdateGroupActionsListValue.endTime() != null) {
                    request.addParameter("ScheduledUpdateGroupActions.member." + scheduledUpdateGroupActionsListIndex
                            + ".EndTime", StringConversion.fromInstant(scheduledUpdateGroupActionsListValue.endTime()));
                }

                if (scheduledUpdateGroupActionsListValue.recurrence() != null) {
                    request.addParameter("ScheduledUpdateGroupActions.member." + scheduledUpdateGroupActionsListIndex
                            + ".Recurrence", StringConversion.fromString(scheduledUpdateGroupActionsListValue.recurrence()));
                }

                if (scheduledUpdateGroupActionsListValue.minSize() != null) {
                    request.addParameter("ScheduledUpdateGroupActions.member." + scheduledUpdateGroupActionsListIndex
                            + ".MinSize", StringConversion.fromInteger(scheduledUpdateGroupActionsListValue.minSize()));
                }

                if (scheduledUpdateGroupActionsListValue.maxSize() != null) {
                    request.addParameter("ScheduledUpdateGroupActions.member." + scheduledUpdateGroupActionsListIndex
                            + ".MaxSize", StringConversion.fromInteger(scheduledUpdateGroupActionsListValue.maxSize()));
                }

                if (scheduledUpdateGroupActionsListValue.desiredCapacity() != null) {
                    request.addParameter("ScheduledUpdateGroupActions.member." + scheduledUpdateGroupActionsListIndex
                            + ".DesiredCapacity",
                            StringConversion.fromInteger(scheduledUpdateGroupActionsListValue.desiredCapacity()));
                }
                scheduledUpdateGroupActionsListIndex++;
            }
        }

        return request;
    }

}
