/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.autoscaling.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;

/**
 * CreateAutoScalingGroupRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CreateAutoScalingGroupRequestMarshaller implements
        Marshaller<Request<CreateAutoScalingGroupRequest>, CreateAutoScalingGroupRequest> {

    public Request<CreateAutoScalingGroupRequest> marshall(CreateAutoScalingGroupRequest createAutoScalingGroupRequest) {

        if (createAutoScalingGroupRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<CreateAutoScalingGroupRequest> request = new DefaultRequest<CreateAutoScalingGroupRequest>(
                createAutoScalingGroupRequest, "AutoScalingClient");
        request.addParameter("Action", "CreateAutoScalingGroup");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (createAutoScalingGroupRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName",
                    StringConversion.fromString(createAutoScalingGroupRequest.autoScalingGroupName()));
        }

        if (createAutoScalingGroupRequest.launchConfigurationName() != null) {
            request.addParameter("LaunchConfigurationName",
                    StringConversion.fromString(createAutoScalingGroupRequest.launchConfigurationName()));
        }

        LaunchTemplateSpecification launchTemplate = createAutoScalingGroupRequest.launchTemplate();
        if (launchTemplate != null) {

            if (launchTemplate.launchTemplateId() != null) {
                request.addParameter("LaunchTemplate.LaunchTemplateId",
                        StringConversion.fromString(launchTemplate.launchTemplateId()));
            }

            if (launchTemplate.launchTemplateName() != null) {
                request.addParameter("LaunchTemplate.LaunchTemplateName",
                        StringConversion.fromString(launchTemplate.launchTemplateName()));
            }

            if (launchTemplate.version() != null) {
                request.addParameter("LaunchTemplate.Version", StringConversion.fromString(launchTemplate.version()));
            }
        }

        if (createAutoScalingGroupRequest.instanceId() != null) {
            request.addParameter("InstanceId", StringConversion.fromString(createAutoScalingGroupRequest.instanceId()));
        }

        if (createAutoScalingGroupRequest.minSize() != null) {
            request.addParameter("MinSize", StringConversion.fromInteger(createAutoScalingGroupRequest.minSize()));
        }

        if (createAutoScalingGroupRequest.maxSize() != null) {
            request.addParameter("MaxSize", StringConversion.fromInteger(createAutoScalingGroupRequest.maxSize()));
        }

        if (createAutoScalingGroupRequest.desiredCapacity() != null) {
            request.addParameter("DesiredCapacity", StringConversion.fromInteger(createAutoScalingGroupRequest.desiredCapacity()));
        }

        if (createAutoScalingGroupRequest.defaultCooldown() != null) {
            request.addParameter("DefaultCooldown", StringConversion.fromInteger(createAutoScalingGroupRequest.defaultCooldown()));
        }

        if (createAutoScalingGroupRequest.availabilityZones().isEmpty()
                && !(createAutoScalingGroupRequest.availabilityZones() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("AvailabilityZones", "");
        } else if (!createAutoScalingGroupRequest.availabilityZones().isEmpty()
                && !(createAutoScalingGroupRequest.availabilityZones() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<String> availabilityZonesList = createAutoScalingGroupRequest.availabilityZones();
            int availabilityZonesListIndex = 1;

            for (String availabilityZonesListValue : availabilityZonesList) {
                if (availabilityZonesListValue != null) {
                    request.addParameter("AvailabilityZones.member." + availabilityZonesListIndex,
                            StringConversion.fromString(availabilityZonesListValue));
                }
                availabilityZonesListIndex++;
            }
        }

        if (createAutoScalingGroupRequest.loadBalancerNames().isEmpty()
                && !(createAutoScalingGroupRequest.loadBalancerNames() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("LoadBalancerNames", "");
        } else if (!createAutoScalingGroupRequest.loadBalancerNames().isEmpty()
                && !(createAutoScalingGroupRequest.loadBalancerNames() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<String> loadBalancerNamesList = createAutoScalingGroupRequest.loadBalancerNames();
            int loadBalancerNamesListIndex = 1;

            for (String loadBalancerNamesListValue : loadBalancerNamesList) {
                if (loadBalancerNamesListValue != null) {
                    request.addParameter("LoadBalancerNames.member." + loadBalancerNamesListIndex,
                            StringConversion.fromString(loadBalancerNamesListValue));
                }
                loadBalancerNamesListIndex++;
            }
        }

        if (createAutoScalingGroupRequest.targetGroupARNs().isEmpty()
                && !(createAutoScalingGroupRequest.targetGroupARNs() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("TargetGroupARNs", "");
        } else if (!createAutoScalingGroupRequest.targetGroupARNs().isEmpty()
                && !(createAutoScalingGroupRequest.targetGroupARNs() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<String> targetGroupARNsList = createAutoScalingGroupRequest.targetGroupARNs();
            int targetGroupARNsListIndex = 1;

            for (String targetGroupARNsListValue : targetGroupARNsList) {
                if (targetGroupARNsListValue != null) {
                    request.addParameter("TargetGroupARNs.member." + targetGroupARNsListIndex,
                            StringConversion.fromString(targetGroupARNsListValue));
                }
                targetGroupARNsListIndex++;
            }
        }

        if (createAutoScalingGroupRequest.healthCheckType() != null) {
            request.addParameter("HealthCheckType", StringConversion.fromString(createAutoScalingGroupRequest.healthCheckType()));
        }

        if (createAutoScalingGroupRequest.healthCheckGracePeriod() != null) {
            request.addParameter("HealthCheckGracePeriod",
                    StringConversion.fromInteger(createAutoScalingGroupRequest.healthCheckGracePeriod()));
        }

        if (createAutoScalingGroupRequest.placementGroup() != null) {
            request.addParameter("PlacementGroup", StringConversion.fromString(createAutoScalingGroupRequest.placementGroup()));
        }

        if (createAutoScalingGroupRequest.vpcZoneIdentifier() != null) {
            request.addParameter("VPCZoneIdentifier",
                    StringConversion.fromString(createAutoScalingGroupRequest.vpcZoneIdentifier()));
        }

        if (createAutoScalingGroupRequest.terminationPolicies().isEmpty()
                && !(createAutoScalingGroupRequest.terminationPolicies() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("TerminationPolicies", "");
        } else if (!createAutoScalingGroupRequest.terminationPolicies().isEmpty()
                && !(createAutoScalingGroupRequest.terminationPolicies() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<String> terminationPoliciesList = createAutoScalingGroupRequest.terminationPolicies();
            int terminationPoliciesListIndex = 1;

            for (String terminationPoliciesListValue : terminationPoliciesList) {
                if (terminationPoliciesListValue != null) {
                    request.addParameter("TerminationPolicies.member." + terminationPoliciesListIndex,
                            StringConversion.fromString(terminationPoliciesListValue));
                }
                terminationPoliciesListIndex++;
            }
        }

        if (createAutoScalingGroupRequest.newInstancesProtectedFromScaleIn() != null) {
            request.addParameter("NewInstancesProtectedFromScaleIn",
                    StringConversion.fromBoolean(createAutoScalingGroupRequest.newInstancesProtectedFromScaleIn()));
        }

        if (createAutoScalingGroupRequest.lifecycleHookSpecificationList().isEmpty()
                && !(createAutoScalingGroupRequest.lifecycleHookSpecificationList() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("LifecycleHookSpecificationList", "");
        } else if (!createAutoScalingGroupRequest.lifecycleHookSpecificationList().isEmpty()
                && !(createAutoScalingGroupRequest.lifecycleHookSpecificationList() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<LifecycleHookSpecification> lifecycleHookSpecificationListList = createAutoScalingGroupRequest
                    .lifecycleHookSpecificationList();
            int lifecycleHookSpecificationListListIndex = 1;

            for (LifecycleHookSpecification lifecycleHookSpecificationListListValue : lifecycleHookSpecificationListList) {

                if (lifecycleHookSpecificationListListValue.lifecycleHookName() != null) {
                    request.addParameter("LifecycleHookSpecificationList.member." + lifecycleHookSpecificationListListIndex
                            + ".LifecycleHookName",
                            StringConversion.fromString(lifecycleHookSpecificationListListValue.lifecycleHookName()));
                }

                if (lifecycleHookSpecificationListListValue.lifecycleTransition() != null) {
                    request.addParameter("LifecycleHookSpecificationList.member." + lifecycleHookSpecificationListListIndex
                            + ".LifecycleTransition",
                            StringConversion.fromString(lifecycleHookSpecificationListListValue.lifecycleTransition()));
                }

                if (lifecycleHookSpecificationListListValue.notificationMetadata() != null) {
                    request.addParameter("LifecycleHookSpecificationList.member." + lifecycleHookSpecificationListListIndex
                            + ".NotificationMetadata",
                            StringConversion.fromString(lifecycleHookSpecificationListListValue.notificationMetadata()));
                }

                if (lifecycleHookSpecificationListListValue.heartbeatTimeout() != null) {
                    request.addParameter("LifecycleHookSpecificationList.member." + lifecycleHookSpecificationListListIndex
                            + ".HeartbeatTimeout",
                            StringConversion.fromInteger(lifecycleHookSpecificationListListValue.heartbeatTimeout()));
                }

                if (lifecycleHookSpecificationListListValue.defaultResult() != null) {
                    request.addParameter("LifecycleHookSpecificationList.member." + lifecycleHookSpecificationListListIndex
                            + ".DefaultResult",
                            StringConversion.fromString(lifecycleHookSpecificationListListValue.defaultResult()));
                }

                if (lifecycleHookSpecificationListListValue.notificationTargetARN() != null) {
                    request.addParameter("LifecycleHookSpecificationList.member." + lifecycleHookSpecificationListListIndex
                            + ".NotificationTargetARN",
                            StringConversion.fromString(lifecycleHookSpecificationListListValue.notificationTargetARN()));
                }

                if (lifecycleHookSpecificationListListValue.roleARN() != null) {
                    request.addParameter("LifecycleHookSpecificationList.member." + lifecycleHookSpecificationListListIndex
                            + ".RoleARN", StringConversion.fromString(lifecycleHookSpecificationListListValue.roleARN()));
                }
                lifecycleHookSpecificationListListIndex++;
            }
        }

        if (createAutoScalingGroupRequest.tags().isEmpty()
                && !(createAutoScalingGroupRequest.tags() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("Tags", "");
        } else if (!createAutoScalingGroupRequest.tags().isEmpty()
                && !(createAutoScalingGroupRequest.tags() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<Tag> tagsList = createAutoScalingGroupRequest.tags();
            int tagsListIndex = 1;

            for (Tag tagsListValue : tagsList) {

                if (tagsListValue.resourceId() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".ResourceId",
                            StringConversion.fromString(tagsListValue.resourceId()));
                }

                if (tagsListValue.resourceType() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".ResourceType",
                            StringConversion.fromString(tagsListValue.resourceType()));
                }

                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Key",
                            StringConversion.fromString(tagsListValue.key()));
                }

                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Value",
                            StringConversion.fromString(tagsListValue.value()));
                }

                if (tagsListValue.propagateAtLaunch() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".PropagateAtLaunch",
                            StringConversion.fromBoolean(tagsListValue.propagateAtLaunch()));
                }
                tagsListIndex++;
            }
        }

        if (createAutoScalingGroupRequest.serviceLinkedRoleARN() != null) {
            request.addParameter("ServiceLinkedRoleARN",
                    StringConversion.fromString(createAutoScalingGroupRequest.serviceLinkedRoleARN()));
        }

        return request;
    }

}
