/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.autoscaling.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;

/**
 * CreateOrUpdateTagsRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CreateOrUpdateTagsRequestMarshaller implements
        Marshaller<Request<CreateOrUpdateTagsRequest>, CreateOrUpdateTagsRequest> {

    public Request<CreateOrUpdateTagsRequest> marshall(CreateOrUpdateTagsRequest createOrUpdateTagsRequest) {

        if (createOrUpdateTagsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<CreateOrUpdateTagsRequest> request = new DefaultRequest<CreateOrUpdateTagsRequest>(createOrUpdateTagsRequest,
                "AutoScalingClient");
        request.addParameter("Action", "CreateOrUpdateTags");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (createOrUpdateTagsRequest.tags().isEmpty()
                && !(createOrUpdateTagsRequest.tags() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("Tags", "");
        } else if (!createOrUpdateTagsRequest.tags().isEmpty()
                && !(createOrUpdateTagsRequest.tags() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<Tag> tagsList = createOrUpdateTagsRequest.tags();
            int tagsListIndex = 1;

            for (Tag tagsListValue : tagsList) {

                if (tagsListValue.resourceId() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".ResourceId",
                            StringConversion.fromString(tagsListValue.resourceId()));
                }

                if (tagsListValue.resourceType() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".ResourceType",
                            StringConversion.fromString(tagsListValue.resourceType()));
                }

                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Key",
                            StringConversion.fromString(tagsListValue.key()));
                }

                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Value",
                            StringConversion.fromString(tagsListValue.value()));
                }

                if (tagsListValue.propagateAtLaunch() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".PropagateAtLaunch",
                            StringConversion.fromBoolean(tagsListValue.propagateAtLaunch()));
                }
                tagsListIndex++;
            }
        }

        return request;
    }

}
