/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.autoscaling.model.*;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

/**
 * CustomizedMetricSpecification StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CustomizedMetricSpecificationUnmarshaller implements
        Unmarshaller<CustomizedMetricSpecification, StaxUnmarshallerContext> {

    public CustomizedMetricSpecification unmarshall(StaxUnmarshallerContext context) throws Exception {
        CustomizedMetricSpecification.Builder customizedMetricSpecification = CustomizedMetricSpecification.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<MetricDimension> dimensions = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                customizedMetricSpecification.dimensions(dimensions);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("MetricName", targetDepth)) {
                    customizedMetricSpecification.metricName(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Namespace", targetDepth)) {
                    customizedMetricSpecification.namespace(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Dimensions", targetDepth)) {
                    dimensions = new ArrayList<MetricDimension>();
                    continue;
                }

                if (context.testExpression("Dimensions/member", targetDepth)) {
                    dimensions.add(MetricDimensionUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Statistic", targetDepth)) {
                    customizedMetricSpecification.statistic(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Unit", targetDepth)) {
                    customizedMetricSpecification.unit(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    customizedMetricSpecification.dimensions(dimensions);
                    break;
                }
            }
        }
        return customizedMetricSpecification.build();
    }

    private static final CustomizedMetricSpecificationUnmarshaller INSTANCE = new CustomizedMetricSpecificationUnmarshaller();

    public static CustomizedMetricSpecificationUnmarshaller getInstance() {
        return INSTANCE;
    }
}
