/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.autoscaling.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;

/**
 * DescribePoliciesRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribePoliciesRequestMarshaller implements Marshaller<Request<DescribePoliciesRequest>, DescribePoliciesRequest> {

    public Request<DescribePoliciesRequest> marshall(DescribePoliciesRequest describePoliciesRequest) {

        if (describePoliciesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<DescribePoliciesRequest> request = new DefaultRequest<DescribePoliciesRequest>(describePoliciesRequest,
                "AutoScalingClient");
        request.addParameter("Action", "DescribePolicies");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (describePoliciesRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName",
                    StringConversion.fromString(describePoliciesRequest.autoScalingGroupName()));
        }

        if (describePoliciesRequest.policyNames().isEmpty()
                && !(describePoliciesRequest.policyNames() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("PolicyNames", "");
        } else if (!describePoliciesRequest.policyNames().isEmpty()
                && !(describePoliciesRequest.policyNames() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<String> policyNamesList = describePoliciesRequest.policyNames();
            int policyNamesListIndex = 1;

            for (String policyNamesListValue : policyNamesList) {
                if (policyNamesListValue != null) {
                    request.addParameter("PolicyNames.member." + policyNamesListIndex,
                            StringConversion.fromString(policyNamesListValue));
                }
                policyNamesListIndex++;
            }
        }

        if (describePoliciesRequest.policyTypes().isEmpty()
                && !(describePoliciesRequest.policyTypes() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("PolicyTypes", "");
        } else if (!describePoliciesRequest.policyTypes().isEmpty()
                && !(describePoliciesRequest.policyTypes() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<String> policyTypesList = describePoliciesRequest.policyTypes();
            int policyTypesListIndex = 1;

            for (String policyTypesListValue : policyTypesList) {
                if (policyTypesListValue != null) {
                    request.addParameter("PolicyTypes.member." + policyTypesListIndex,
                            StringConversion.fromString(policyTypesListValue));
                }
                policyTypesListIndex++;
            }
        }

        if (describePoliciesRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString(describePoliciesRequest.nextToken()));
        }

        if (describePoliciesRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringConversion.fromInteger(describePoliciesRequest.maxRecords()));
        }

        return request;
    }

}
