/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.autoscaling.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;

/**
 * DescribeScalingActivitiesRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeScalingActivitiesRequestMarshaller implements
        Marshaller<Request<DescribeScalingActivitiesRequest>, DescribeScalingActivitiesRequest> {

    public Request<DescribeScalingActivitiesRequest> marshall(DescribeScalingActivitiesRequest describeScalingActivitiesRequest) {

        if (describeScalingActivitiesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<DescribeScalingActivitiesRequest> request = new DefaultRequest<DescribeScalingActivitiesRequest>(
                describeScalingActivitiesRequest, "AutoScalingClient");
        request.addParameter("Action", "DescribeScalingActivities");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (describeScalingActivitiesRequest.activityIds().isEmpty()
                && !(describeScalingActivitiesRequest.activityIds() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("ActivityIds", "");
        } else if (!describeScalingActivitiesRequest.activityIds().isEmpty()
                && !(describeScalingActivitiesRequest.activityIds() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<String> activityIdsList = describeScalingActivitiesRequest.activityIds();
            int activityIdsListIndex = 1;

            for (String activityIdsListValue : activityIdsList) {
                if (activityIdsListValue != null) {
                    request.addParameter("ActivityIds.member." + activityIdsListIndex,
                            StringConversion.fromString(activityIdsListValue));
                }
                activityIdsListIndex++;
            }
        }

        if (describeScalingActivitiesRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName",
                    StringConversion.fromString(describeScalingActivitiesRequest.autoScalingGroupName()));
        }

        if (describeScalingActivitiesRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringConversion.fromInteger(describeScalingActivitiesRequest.maxRecords()));
        }

        if (describeScalingActivitiesRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString(describeScalingActivitiesRequest.nextToken()));
        }

        return request;
    }

}
