/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.autoscaling.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;

/**
 * PutScalingPolicyRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class PutScalingPolicyRequestMarshaller implements Marshaller<Request<PutScalingPolicyRequest>, PutScalingPolicyRequest> {

    public Request<PutScalingPolicyRequest> marshall(PutScalingPolicyRequest putScalingPolicyRequest) {

        if (putScalingPolicyRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<PutScalingPolicyRequest> request = new DefaultRequest<PutScalingPolicyRequest>(putScalingPolicyRequest,
                "AutoScalingClient");
        request.addParameter("Action", "PutScalingPolicy");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (putScalingPolicyRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName",
                    StringConversion.fromString(putScalingPolicyRequest.autoScalingGroupName()));
        }

        if (putScalingPolicyRequest.policyName() != null) {
            request.addParameter("PolicyName", StringConversion.fromString(putScalingPolicyRequest.policyName()));
        }

        if (putScalingPolicyRequest.policyType() != null) {
            request.addParameter("PolicyType", StringConversion.fromString(putScalingPolicyRequest.policyType()));
        }

        if (putScalingPolicyRequest.adjustmentType() != null) {
            request.addParameter("AdjustmentType", StringConversion.fromString(putScalingPolicyRequest.adjustmentType()));
        }

        if (putScalingPolicyRequest.minAdjustmentStep() != null) {
            request.addParameter("MinAdjustmentStep", StringConversion.fromInteger(putScalingPolicyRequest.minAdjustmentStep()));
        }

        if (putScalingPolicyRequest.minAdjustmentMagnitude() != null) {
            request.addParameter("MinAdjustmentMagnitude",
                    StringConversion.fromInteger(putScalingPolicyRequest.minAdjustmentMagnitude()));
        }

        if (putScalingPolicyRequest.scalingAdjustment() != null) {
            request.addParameter("ScalingAdjustment", StringConversion.fromInteger(putScalingPolicyRequest.scalingAdjustment()));
        }

        if (putScalingPolicyRequest.cooldown() != null) {
            request.addParameter("Cooldown", StringConversion.fromInteger(putScalingPolicyRequest.cooldown()));
        }

        if (putScalingPolicyRequest.metricAggregationType() != null) {
            request.addParameter("MetricAggregationType",
                    StringConversion.fromString(putScalingPolicyRequest.metricAggregationType()));
        }

        if (putScalingPolicyRequest.stepAdjustments().isEmpty()
                && !(putScalingPolicyRequest.stepAdjustments() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("StepAdjustments", "");
        } else if (!putScalingPolicyRequest.stepAdjustments().isEmpty()
                && !(putScalingPolicyRequest.stepAdjustments() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<StepAdjustment> stepAdjustmentsList = putScalingPolicyRequest.stepAdjustments();
            int stepAdjustmentsListIndex = 1;

            for (StepAdjustment stepAdjustmentsListValue : stepAdjustmentsList) {

                if (stepAdjustmentsListValue.metricIntervalLowerBound() != null) {
                    request.addParameter("StepAdjustments.member." + stepAdjustmentsListIndex + ".MetricIntervalLowerBound",
                            StringConversion.fromDouble(stepAdjustmentsListValue.metricIntervalLowerBound()));
                }

                if (stepAdjustmentsListValue.metricIntervalUpperBound() != null) {
                    request.addParameter("StepAdjustments.member." + stepAdjustmentsListIndex + ".MetricIntervalUpperBound",
                            StringConversion.fromDouble(stepAdjustmentsListValue.metricIntervalUpperBound()));
                }

                if (stepAdjustmentsListValue.scalingAdjustment() != null) {
                    request.addParameter("StepAdjustments.member." + stepAdjustmentsListIndex + ".ScalingAdjustment",
                            StringConversion.fromInteger(stepAdjustmentsListValue.scalingAdjustment()));
                }
                stepAdjustmentsListIndex++;
            }
        }

        if (putScalingPolicyRequest.estimatedInstanceWarmup() != null) {
            request.addParameter("EstimatedInstanceWarmup",
                    StringConversion.fromInteger(putScalingPolicyRequest.estimatedInstanceWarmup()));
        }

        TargetTrackingConfiguration targetTrackingConfiguration = putScalingPolicyRequest.targetTrackingConfiguration();
        if (targetTrackingConfiguration != null) {

            PredefinedMetricSpecification predefinedMetricSpecification = targetTrackingConfiguration
                    .predefinedMetricSpecification();
            if (predefinedMetricSpecification != null) {

                if (predefinedMetricSpecification.predefinedMetricTypeAsString() != null) {
                    request.addParameter("TargetTrackingConfiguration.PredefinedMetricSpecification.PredefinedMetricType",
                            StringConversion.fromString(predefinedMetricSpecification.predefinedMetricTypeAsString()));
                }

                if (predefinedMetricSpecification.resourceLabel() != null) {
                    request.addParameter("TargetTrackingConfiguration.PredefinedMetricSpecification.ResourceLabel",
                            StringConversion.fromString(predefinedMetricSpecification.resourceLabel()));
                }
            }

            CustomizedMetricSpecification customizedMetricSpecification = targetTrackingConfiguration
                    .customizedMetricSpecification();
            if (customizedMetricSpecification != null) {

                if (customizedMetricSpecification.metricName() != null) {
                    request.addParameter("TargetTrackingConfiguration.CustomizedMetricSpecification.MetricName",
                            StringConversion.fromString(customizedMetricSpecification.metricName()));
                }

                if (customizedMetricSpecification.namespace() != null) {
                    request.addParameter("TargetTrackingConfiguration.CustomizedMetricSpecification.Namespace",
                            StringConversion.fromString(customizedMetricSpecification.namespace()));
                }

                if (customizedMetricSpecification.dimensions().isEmpty()
                        && !(customizedMetricSpecification.dimensions() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                    request.addParameter("TargetTrackingConfiguration.CustomizedMetricSpecification.Dimensions", "");
                } else if (!customizedMetricSpecification.dimensions().isEmpty()
                        && !(customizedMetricSpecification.dimensions() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                    java.util.List<MetricDimension> dimensionsList = customizedMetricSpecification.dimensions();
                    int dimensionsListIndex = 1;

                    for (MetricDimension dimensionsListValue : dimensionsList) {

                        if (dimensionsListValue.name() != null) {
                            request.addParameter("TargetTrackingConfiguration.CustomizedMetricSpecification.Dimensions.member."
                                    + dimensionsListIndex + ".Name", StringConversion.fromString(dimensionsListValue.name()));
                        }

                        if (dimensionsListValue.value() != null) {
                            request.addParameter("TargetTrackingConfiguration.CustomizedMetricSpecification.Dimensions.member."
                                    + dimensionsListIndex + ".Value", StringConversion.fromString(dimensionsListValue.value()));
                        }
                        dimensionsListIndex++;
                    }
                }

                if (customizedMetricSpecification.statisticAsString() != null) {
                    request.addParameter("TargetTrackingConfiguration.CustomizedMetricSpecification.Statistic",
                            StringConversion.fromString(customizedMetricSpecification.statisticAsString()));
                }

                if (customizedMetricSpecification.unit() != null) {
                    request.addParameter("TargetTrackingConfiguration.CustomizedMetricSpecification.Unit",
                            StringConversion.fromString(customizedMetricSpecification.unit()));
                }
            }

            if (targetTrackingConfiguration.targetValue() != null) {
                request.addParameter("TargetTrackingConfiguration.TargetValue",
                        StringConversion.fromDouble(targetTrackingConfiguration.targetValue()));
            }

            if (targetTrackingConfiguration.disableScaleIn() != null) {
                request.addParameter("TargetTrackingConfiguration.DisableScaleIn",
                        StringConversion.fromBoolean(targetTrackingConfiguration.disableScaleIn()));
            }
        }

        return request;
    }

}
