/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.autoscaling.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;

/**
 * PutScheduledUpdateGroupActionRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class PutScheduledUpdateGroupActionRequestMarshaller implements
        Marshaller<Request<PutScheduledUpdateGroupActionRequest>, PutScheduledUpdateGroupActionRequest> {

    public Request<PutScheduledUpdateGroupActionRequest> marshall(
            PutScheduledUpdateGroupActionRequest putScheduledUpdateGroupActionRequest) {

        if (putScheduledUpdateGroupActionRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<PutScheduledUpdateGroupActionRequest> request = new DefaultRequest<PutScheduledUpdateGroupActionRequest>(
                putScheduledUpdateGroupActionRequest, "AutoScalingClient");
        request.addParameter("Action", "PutScheduledUpdateGroupAction");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (putScheduledUpdateGroupActionRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName",
                    StringConversion.fromString(putScheduledUpdateGroupActionRequest.autoScalingGroupName()));
        }

        if (putScheduledUpdateGroupActionRequest.scheduledActionName() != null) {
            request.addParameter("ScheduledActionName",
                    StringConversion.fromString(putScheduledUpdateGroupActionRequest.scheduledActionName()));
        }

        if (putScheduledUpdateGroupActionRequest.time() != null) {
            request.addParameter("Time", StringConversion.fromInstant(putScheduledUpdateGroupActionRequest.time()));
        }

        if (putScheduledUpdateGroupActionRequest.startTime() != null) {
            request.addParameter("StartTime", StringConversion.fromInstant(putScheduledUpdateGroupActionRequest.startTime()));
        }

        if (putScheduledUpdateGroupActionRequest.endTime() != null) {
            request.addParameter("EndTime", StringConversion.fromInstant(putScheduledUpdateGroupActionRequest.endTime()));
        }

        if (putScheduledUpdateGroupActionRequest.recurrence() != null) {
            request.addParameter("Recurrence", StringConversion.fromString(putScheduledUpdateGroupActionRequest.recurrence()));
        }

        if (putScheduledUpdateGroupActionRequest.minSize() != null) {
            request.addParameter("MinSize", StringConversion.fromInteger(putScheduledUpdateGroupActionRequest.minSize()));
        }

        if (putScheduledUpdateGroupActionRequest.maxSize() != null) {
            request.addParameter("MaxSize", StringConversion.fromInteger(putScheduledUpdateGroupActionRequest.maxSize()));
        }

        if (putScheduledUpdateGroupActionRequest.desiredCapacity() != null) {
            request.addParameter("DesiredCapacity",
                    StringConversion.fromInteger(putScheduledUpdateGroupActionRequest.desiredCapacity()));
        }

        return request;
    }

}
