/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingRequest;
import software.amazon.awssdk.services.autoscaling.model.ScheduledActionNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchDeleteScheduledActionRequest
extends AutoScalingRequest
implements ToCopyableBuilder<Builder, BatchDeleteScheduledActionRequest> {
    private final String autoScalingGroupName;
    private final List<String> scheduledActionNames;

    private BatchDeleteScheduledActionRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.scheduledActionNames = builder.scheduledActionNames;
    }

    public String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public List<String> scheduledActionNames() {
        return this.scheduledActionNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledActionNames());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteScheduledActionRequest)) {
            return false;
        }
        BatchDeleteScheduledActionRequest other = (BatchDeleteScheduledActionRequest)((Object)obj);
        return Objects.equals(this.autoScalingGroupName(), other.autoScalingGroupName()) && Objects.equals(this.scheduledActionNames(), other.scheduledActionNames());
    }

    public String toString() {
        return ToString.builder((String)"BatchDeleteScheduledActionRequest").add("AutoScalingGroupName", (Object)this.autoScalingGroupName()).add("ScheduledActionNames", this.scheduledActionNames()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoScalingGroupName": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroupName()));
            }
            case "ScheduledActionNames": {
                return Optional.ofNullable(clazz.cast(this.scheduledActionNames()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AutoScalingRequest.BuilderImpl
    implements Builder {
        private String autoScalingGroupName;
        private List<String> scheduledActionNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteScheduledActionRequest model) {
            super(model);
            this.autoScalingGroupName(model.autoScalingGroupName);
            this.scheduledActionNames(model.scheduledActionNames);
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final Collection<String> getScheduledActionNames() {
            return this.scheduledActionNames;
        }

        @Override
        public final Builder scheduledActionNames(Collection<String> scheduledActionNames) {
            this.scheduledActionNames = ScheduledActionNamesCopier.copy(scheduledActionNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduledActionNames(String ... scheduledActionNames) {
            this.scheduledActionNames(Arrays.asList(scheduledActionNames));
            return this;
        }

        public final void setScheduledActionNames(Collection<String> scheduledActionNames) {
            this.scheduledActionNames = ScheduledActionNamesCopier.copy(scheduledActionNames);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchDeleteScheduledActionRequest build() {
            return new BatchDeleteScheduledActionRequest(this);
        }
    }

    public static interface Builder
    extends AutoScalingRequest.Builder,
    CopyableBuilder<Builder, BatchDeleteScheduledActionRequest> {
        public Builder autoScalingGroupName(String var1);

        public Builder scheduledActionNames(Collection<String> var1);

        public Builder scheduledActionNames(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

