/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.autoscaling.model.ActivityIdsCopier;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeScalingActivitiesRequest
extends AutoScalingRequest
implements ToCopyableBuilder<Builder, DescribeScalingActivitiesRequest> {
    private final List<String> activityIds;
    private final String autoScalingGroupName;
    private final Integer maxRecords;
    private final String nextToken;

    private DescribeScalingActivitiesRequest(BuilderImpl builder) {
        super(builder);
        this.activityIds = builder.activityIds;
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.maxRecords = builder.maxRecords;
        this.nextToken = builder.nextToken;
    }

    public List<String> activityIds() {
        return this.activityIds;
    }

    public String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public Integer maxRecords() {
        return this.maxRecords;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.activityIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScalingActivitiesRequest)) {
            return false;
        }
        DescribeScalingActivitiesRequest other = (DescribeScalingActivitiesRequest)((Object)obj);
        return Objects.equals(this.activityIds(), other.activityIds()) && Objects.equals(this.autoScalingGroupName(), other.autoScalingGroupName()) && Objects.equals(this.maxRecords(), other.maxRecords()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeScalingActivitiesRequest").add("ActivityIds", this.activityIds()).add("AutoScalingGroupName", (Object)this.autoScalingGroupName()).add("MaxRecords", (Object)this.maxRecords()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActivityIds": {
                return Optional.ofNullable(clazz.cast(this.activityIds()));
            }
            case "AutoScalingGroupName": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroupName()));
            }
            case "MaxRecords": {
                return Optional.ofNullable(clazz.cast(this.maxRecords()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AutoScalingRequest.BuilderImpl
    implements Builder {
        private List<String> activityIds = DefaultSdkAutoConstructList.getInstance();
        private String autoScalingGroupName;
        private Integer maxRecords;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScalingActivitiesRequest model) {
            super(model);
            this.activityIds(model.activityIds);
            this.autoScalingGroupName(model.autoScalingGroupName);
            this.maxRecords(model.maxRecords);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getActivityIds() {
            return this.activityIds;
        }

        @Override
        public final Builder activityIds(Collection<String> activityIds) {
            this.activityIds = ActivityIdsCopier.copy(activityIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activityIds(String ... activityIds) {
            this.activityIds(Arrays.asList(activityIds));
            return this;
        }

        public final void setActivityIds(Collection<String> activityIds) {
            this.activityIds = ActivityIdsCopier.copy(activityIds);
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeScalingActivitiesRequest build() {
            return new DescribeScalingActivitiesRequest(this);
        }
    }

    public static interface Builder
    extends AutoScalingRequest.Builder,
    CopyableBuilder<Builder, DescribeScalingActivitiesRequest> {
        public Builder activityIds(Collection<String> var1);

        public Builder activityIds(String ... var1);

        public Builder autoScalingGroupName(String var1);

        public Builder maxRecords(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

