/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScheduledUpdateGroupAction
implements ToCopyableBuilder<Builder, ScheduledUpdateGroupAction> {
    private final String autoScalingGroupName;
    private final String scheduledActionName;
    private final String scheduledActionARN;
    private final Instant time;
    private final Instant startTime;
    private final Instant endTime;
    private final String recurrence;
    private final Integer minSize;
    private final Integer maxSize;
    private final Integer desiredCapacity;

    private ScheduledUpdateGroupAction(BuilderImpl builder) {
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.scheduledActionName = builder.scheduledActionName;
        this.scheduledActionARN = builder.scheduledActionARN;
        this.time = builder.time;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.recurrence = builder.recurrence;
        this.minSize = builder.minSize;
        this.maxSize = builder.maxSize;
        this.desiredCapacity = builder.desiredCapacity;
    }

    public String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public String scheduledActionName() {
        return this.scheduledActionName;
    }

    public String scheduledActionARN() {
        return this.scheduledActionARN;
    }

    public Instant time() {
        return this.time;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public String recurrence() {
        return this.recurrence;
    }

    public Integer minSize() {
        return this.minSize;
    }

    public Integer maxSize() {
        return this.maxSize;
    }

    public Integer desiredCapacity() {
        return this.desiredCapacity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledActionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledActionARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.time());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.recurrence());
        hashCode = 31 * hashCode + Objects.hashCode(this.minSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredCapacity());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledUpdateGroupAction)) {
            return false;
        }
        ScheduledUpdateGroupAction other = (ScheduledUpdateGroupAction)obj;
        return Objects.equals(this.autoScalingGroupName(), other.autoScalingGroupName()) && Objects.equals(this.scheduledActionName(), other.scheduledActionName()) && Objects.equals(this.scheduledActionARN(), other.scheduledActionARN()) && Objects.equals(this.time(), other.time()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.recurrence(), other.recurrence()) && Objects.equals(this.minSize(), other.minSize()) && Objects.equals(this.maxSize(), other.maxSize()) && Objects.equals(this.desiredCapacity(), other.desiredCapacity());
    }

    public String toString() {
        return ToString.builder((String)"ScheduledUpdateGroupAction").add("AutoScalingGroupName", (Object)this.autoScalingGroupName()).add("ScheduledActionName", (Object)this.scheduledActionName()).add("ScheduledActionARN", (Object)this.scheduledActionARN()).add("Time", (Object)this.time()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("Recurrence", (Object)this.recurrence()).add("MinSize", (Object)this.minSize()).add("MaxSize", (Object)this.maxSize()).add("DesiredCapacity", (Object)this.desiredCapacity()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoScalingGroupName": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroupName()));
            }
            case "ScheduledActionName": {
                return Optional.ofNullable(clazz.cast(this.scheduledActionName()));
            }
            case "ScheduledActionARN": {
                return Optional.ofNullable(clazz.cast(this.scheduledActionARN()));
            }
            case "Time": {
                return Optional.ofNullable(clazz.cast(this.time()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "Recurrence": {
                return Optional.ofNullable(clazz.cast(this.recurrence()));
            }
            case "MinSize": {
                return Optional.ofNullable(clazz.cast(this.minSize()));
            }
            case "MaxSize": {
                return Optional.ofNullable(clazz.cast(this.maxSize()));
            }
            case "DesiredCapacity": {
                return Optional.ofNullable(clazz.cast(this.desiredCapacity()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String autoScalingGroupName;
        private String scheduledActionName;
        private String scheduledActionARN;
        private Instant time;
        private Instant startTime;
        private Instant endTime;
        private String recurrence;
        private Integer minSize;
        private Integer maxSize;
        private Integer desiredCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledUpdateGroupAction model) {
            this.autoScalingGroupName(model.autoScalingGroupName);
            this.scheduledActionName(model.scheduledActionName);
            this.scheduledActionARN(model.scheduledActionARN);
            this.time(model.time);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.recurrence(model.recurrence);
            this.minSize(model.minSize);
            this.maxSize(model.maxSize);
            this.desiredCapacity(model.desiredCapacity);
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final String getScheduledActionName() {
            return this.scheduledActionName;
        }

        @Override
        public final Builder scheduledActionName(String scheduledActionName) {
            this.scheduledActionName = scheduledActionName;
            return this;
        }

        public final void setScheduledActionName(String scheduledActionName) {
            this.scheduledActionName = scheduledActionName;
        }

        public final String getScheduledActionARN() {
            return this.scheduledActionARN;
        }

        @Override
        public final Builder scheduledActionARN(String scheduledActionARN) {
            this.scheduledActionARN = scheduledActionARN;
            return this;
        }

        public final void setScheduledActionARN(String scheduledActionARN) {
            this.scheduledActionARN = scheduledActionARN;
        }

        public final Instant getTime() {
            return this.time;
        }

        @Override
        public final Builder time(Instant time) {
            this.time = time;
            return this;
        }

        public final void setTime(Instant time) {
            this.time = time;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final String getRecurrence() {
            return this.recurrence;
        }

        @Override
        public final Builder recurrence(String recurrence) {
            this.recurrence = recurrence;
            return this;
        }

        public final void setRecurrence(String recurrence) {
            this.recurrence = recurrence;
        }

        public final Integer getMinSize() {
            return this.minSize;
        }

        @Override
        public final Builder minSize(Integer minSize) {
            this.minSize = minSize;
            return this;
        }

        public final void setMinSize(Integer minSize) {
            this.minSize = minSize;
        }

        public final Integer getMaxSize() {
            return this.maxSize;
        }

        @Override
        public final Builder maxSize(Integer maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public final void setMaxSize(Integer maxSize) {
            this.maxSize = maxSize;
        }

        public final Integer getDesiredCapacity() {
            return this.desiredCapacity;
        }

        @Override
        public final Builder desiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
            return this;
        }

        public final void setDesiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
        }

        public ScheduledUpdateGroupAction build() {
            return new ScheduledUpdateGroupAction(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ScheduledUpdateGroupAction> {
        public Builder autoScalingGroupName(String var1);

        public Builder scheduledActionName(String var1);

        public Builder scheduledActionARN(String var1);

        public Builder time(Instant var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder recurrence(String var1);

        public Builder minSize(Integer var1);

        public Builder maxSize(Integer var1);

        public Builder desiredCapacity(Integer var1);
    }
}

