/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Tag
implements ToCopyableBuilder<Builder, Tag> {
    private final String resourceId;
    private final String resourceType;
    private final String key;
    private final String value;
    private final Boolean propagateAtLaunch;

    private Tag(BuilderImpl builder) {
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
        this.key = builder.key;
        this.value = builder.value;
        this.propagateAtLaunch = builder.propagateAtLaunch;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public String key() {
        return this.key;
    }

    public String value() {
        return this.value;
    }

    public Boolean propagateAtLaunch() {
        return this.propagateAtLaunch;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.propagateAtLaunch());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Tag)) {
            return false;
        }
        Tag other = (Tag)obj;
        return Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.key(), other.key()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.propagateAtLaunch(), other.propagateAtLaunch());
    }

    public String toString() {
        return ToString.builder((String)"Tag").add("ResourceId", (Object)this.resourceId()).add("ResourceType", (Object)this.resourceType()).add("Key", (Object)this.key()).add("Value", (Object)this.value()).add("PropagateAtLaunch", (Object)this.propagateAtLaunch()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "Key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "PropagateAtLaunch": {
                return Optional.ofNullable(clazz.cast(this.propagateAtLaunch()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceId;
        private String resourceType;
        private String key;
        private String value;
        private Boolean propagateAtLaunch;

        private BuilderImpl() {
        }

        private BuilderImpl(Tag model) {
            this.resourceId(model.resourceId);
            this.resourceType(model.resourceType);
            this.key(model.key);
            this.value(model.value);
            this.propagateAtLaunch(model.propagateAtLaunch);
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getKey() {
            return this.key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getValue() {
            return this.value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final Boolean getPropagateAtLaunch() {
            return this.propagateAtLaunch;
        }

        @Override
        public final Builder propagateAtLaunch(Boolean propagateAtLaunch) {
            this.propagateAtLaunch = propagateAtLaunch;
            return this;
        }

        public final void setPropagateAtLaunch(Boolean propagateAtLaunch) {
            this.propagateAtLaunch = propagateAtLaunch;
        }

        public Tag build() {
            return new Tag(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Tag> {
        public Builder resourceId(String var1);

        public Builder resourceType(String var1);

        public Builder key(String var1);

        public Builder value(String var1);

        public Builder propagateAtLaunch(Boolean var1);
    }
}

