/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.autoscaling.model.CustomizedMetricSpecification;
import software.amazon.awssdk.services.autoscaling.model.PredefinedMetricSpecification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TargetTrackingConfiguration
implements ToCopyableBuilder<Builder, TargetTrackingConfiguration> {
    private final PredefinedMetricSpecification predefinedMetricSpecification;
    private final CustomizedMetricSpecification customizedMetricSpecification;
    private final Double targetValue;
    private final Boolean disableScaleIn;

    private TargetTrackingConfiguration(BuilderImpl builder) {
        this.predefinedMetricSpecification = builder.predefinedMetricSpecification;
        this.customizedMetricSpecification = builder.customizedMetricSpecification;
        this.targetValue = builder.targetValue;
        this.disableScaleIn = builder.disableScaleIn;
    }

    public PredefinedMetricSpecification predefinedMetricSpecification() {
        return this.predefinedMetricSpecification;
    }

    public CustomizedMetricSpecification customizedMetricSpecification() {
        return this.customizedMetricSpecification;
    }

    public Double targetValue() {
        return this.targetValue;
    }

    public Boolean disableScaleIn() {
        return this.disableScaleIn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.predefinedMetricSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.customizedMetricSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.disableScaleIn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetTrackingConfiguration)) {
            return false;
        }
        TargetTrackingConfiguration other = (TargetTrackingConfiguration)obj;
        return Objects.equals(this.predefinedMetricSpecification(), other.predefinedMetricSpecification()) && Objects.equals(this.customizedMetricSpecification(), other.customizedMetricSpecification()) && Objects.equals(this.targetValue(), other.targetValue()) && Objects.equals(this.disableScaleIn(), other.disableScaleIn());
    }

    public String toString() {
        return ToString.builder((String)"TargetTrackingConfiguration").add("PredefinedMetricSpecification", (Object)this.predefinedMetricSpecification()).add("CustomizedMetricSpecification", (Object)this.customizedMetricSpecification()).add("TargetValue", (Object)this.targetValue()).add("DisableScaleIn", (Object)this.disableScaleIn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PredefinedMetricSpecification": {
                return Optional.ofNullable(clazz.cast(this.predefinedMetricSpecification()));
            }
            case "CustomizedMetricSpecification": {
                return Optional.ofNullable(clazz.cast(this.customizedMetricSpecification()));
            }
            case "TargetValue": {
                return Optional.ofNullable(clazz.cast(this.targetValue()));
            }
            case "DisableScaleIn": {
                return Optional.ofNullable(clazz.cast(this.disableScaleIn()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private PredefinedMetricSpecification predefinedMetricSpecification;
        private CustomizedMetricSpecification customizedMetricSpecification;
        private Double targetValue;
        private Boolean disableScaleIn;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetTrackingConfiguration model) {
            this.predefinedMetricSpecification(model.predefinedMetricSpecification);
            this.customizedMetricSpecification(model.customizedMetricSpecification);
            this.targetValue(model.targetValue);
            this.disableScaleIn(model.disableScaleIn);
        }

        public final PredefinedMetricSpecification.Builder getPredefinedMetricSpecification() {
            return this.predefinedMetricSpecification != null ? this.predefinedMetricSpecification.toBuilder() : null;
        }

        @Override
        public final Builder predefinedMetricSpecification(PredefinedMetricSpecification predefinedMetricSpecification) {
            this.predefinedMetricSpecification = predefinedMetricSpecification;
            return this;
        }

        public final void setPredefinedMetricSpecification(PredefinedMetricSpecification.BuilderImpl predefinedMetricSpecification) {
            this.predefinedMetricSpecification = predefinedMetricSpecification != null ? predefinedMetricSpecification.build() : null;
        }

        public final CustomizedMetricSpecification.Builder getCustomizedMetricSpecification() {
            return this.customizedMetricSpecification != null ? this.customizedMetricSpecification.toBuilder() : null;
        }

        @Override
        public final Builder customizedMetricSpecification(CustomizedMetricSpecification customizedMetricSpecification) {
            this.customizedMetricSpecification = customizedMetricSpecification;
            return this;
        }

        public final void setCustomizedMetricSpecification(CustomizedMetricSpecification.BuilderImpl customizedMetricSpecification) {
            this.customizedMetricSpecification = customizedMetricSpecification != null ? customizedMetricSpecification.build() : null;
        }

        public final Double getTargetValue() {
            return this.targetValue;
        }

        @Override
        public final Builder targetValue(Double targetValue) {
            this.targetValue = targetValue;
            return this;
        }

        public final void setTargetValue(Double targetValue) {
            this.targetValue = targetValue;
        }

        public final Boolean getDisableScaleIn() {
            return this.disableScaleIn;
        }

        @Override
        public final Builder disableScaleIn(Boolean disableScaleIn) {
            this.disableScaleIn = disableScaleIn;
            return this;
        }

        public final void setDisableScaleIn(Boolean disableScaleIn) {
            this.disableScaleIn = disableScaleIn;
        }

        public TargetTrackingConfiguration build() {
            return new TargetTrackingConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TargetTrackingConfiguration> {
        public Builder predefinedMetricSpecification(PredefinedMetricSpecification var1);

        default public Builder predefinedMetricSpecification(Consumer<PredefinedMetricSpecification.Builder> predefinedMetricSpecification) {
            return this.predefinedMetricSpecification((PredefinedMetricSpecification)((PredefinedMetricSpecification.Builder)PredefinedMetricSpecification.builder().applyMutation(predefinedMetricSpecification)).build());
        }

        public Builder customizedMetricSpecification(CustomizedMetricSpecification var1);

        default public Builder customizedMetricSpecification(Consumer<CustomizedMetricSpecification.Builder> customizedMetricSpecification) {
            return this.customizedMetricSpecification((CustomizedMetricSpecification)((CustomizedMetricSpecification.Builder)CustomizedMetricSpecification.builder().applyMutation(customizedMetricSpecification)).build());
        }

        public Builder targetValue(Double var1);

        public Builder disableScaleIn(Boolean var1);
    }
}

