/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.autoscaling.model.AttachLoadBalancersRequest;

public class AttachLoadBalancersRequestMarshaller
implements Marshaller<Request<AttachLoadBalancersRequest>, AttachLoadBalancersRequest> {
    public Request<AttachLoadBalancersRequest> marshall(AttachLoadBalancersRequest attachLoadBalancersRequest) {
        if (attachLoadBalancersRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)attachLoadBalancersRequest, "AutoScalingClient");
        request.addParameter("Action", "AttachLoadBalancers");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (attachLoadBalancersRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringConversion.fromString((String)attachLoadBalancersRequest.autoScalingGroupName()));
        }
        if (attachLoadBalancersRequest.loadBalancerNames().isEmpty() && !(attachLoadBalancersRequest.loadBalancerNames() instanceof SdkAutoConstructList)) {
            request.addParameter("LoadBalancerNames", "");
        } else if (!attachLoadBalancersRequest.loadBalancerNames().isEmpty() && !(attachLoadBalancersRequest.loadBalancerNames() instanceof SdkAutoConstructList)) {
            List<String> loadBalancerNamesList = attachLoadBalancersRequest.loadBalancerNames();
            int loadBalancerNamesListIndex = 1;
            for (String loadBalancerNamesListValue : loadBalancerNamesList) {
                if (loadBalancerNamesListValue != null) {
                    request.addParameter("LoadBalancerNames.member." + loadBalancerNamesListIndex, StringConversion.fromString((String)loadBalancerNamesListValue));
                }
                ++loadBalancerNamesListIndex;
            }
        }
        return request;
    }
}

