/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.autoscaling.model.BatchDeleteScheduledActionRequest;

public class BatchDeleteScheduledActionRequestMarshaller
implements Marshaller<Request<BatchDeleteScheduledActionRequest>, BatchDeleteScheduledActionRequest> {
    public Request<BatchDeleteScheduledActionRequest> marshall(BatchDeleteScheduledActionRequest batchDeleteScheduledActionRequest) {
        if (batchDeleteScheduledActionRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)batchDeleteScheduledActionRequest, "AutoScalingClient");
        request.addParameter("Action", "BatchDeleteScheduledAction");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (batchDeleteScheduledActionRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringConversion.fromString((String)batchDeleteScheduledActionRequest.autoScalingGroupName()));
        }
        if (batchDeleteScheduledActionRequest.scheduledActionNames().isEmpty() && !(batchDeleteScheduledActionRequest.scheduledActionNames() instanceof SdkAutoConstructList)) {
            request.addParameter("ScheduledActionNames", "");
        } else if (!batchDeleteScheduledActionRequest.scheduledActionNames().isEmpty() && !(batchDeleteScheduledActionRequest.scheduledActionNames() instanceof SdkAutoConstructList)) {
            List<String> scheduledActionNamesList = batchDeleteScheduledActionRequest.scheduledActionNames();
            int scheduledActionNamesListIndex = 1;
            for (String scheduledActionNamesListValue : scheduledActionNamesList) {
                if (scheduledActionNamesListValue != null) {
                    request.addParameter("ScheduledActionNames.member." + scheduledActionNamesListIndex, StringConversion.fromString((String)scheduledActionNamesListValue));
                }
                ++scheduledActionNamesListIndex;
            }
        }
        return request;
    }
}

