/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.autoscaling.model.BatchPutScheduledUpdateGroupActionRequest;
import software.amazon.awssdk.services.autoscaling.model.ScheduledUpdateGroupActionRequest;

public class BatchPutScheduledUpdateGroupActionRequestMarshaller
implements Marshaller<Request<BatchPutScheduledUpdateGroupActionRequest>, BatchPutScheduledUpdateGroupActionRequest> {
    public Request<BatchPutScheduledUpdateGroupActionRequest> marshall(BatchPutScheduledUpdateGroupActionRequest batchPutScheduledUpdateGroupActionRequest) {
        if (batchPutScheduledUpdateGroupActionRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)batchPutScheduledUpdateGroupActionRequest, "AutoScalingClient");
        request.addParameter("Action", "BatchPutScheduledUpdateGroupAction");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (batchPutScheduledUpdateGroupActionRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringConversion.fromString((String)batchPutScheduledUpdateGroupActionRequest.autoScalingGroupName()));
        }
        if (batchPutScheduledUpdateGroupActionRequest.scheduledUpdateGroupActions().isEmpty() && !(batchPutScheduledUpdateGroupActionRequest.scheduledUpdateGroupActions() instanceof SdkAutoConstructList)) {
            request.addParameter("ScheduledUpdateGroupActions", "");
        } else if (!batchPutScheduledUpdateGroupActionRequest.scheduledUpdateGroupActions().isEmpty() && !(batchPutScheduledUpdateGroupActionRequest.scheduledUpdateGroupActions() instanceof SdkAutoConstructList)) {
            List<ScheduledUpdateGroupActionRequest> scheduledUpdateGroupActionsList = batchPutScheduledUpdateGroupActionRequest.scheduledUpdateGroupActions();
            int scheduledUpdateGroupActionsListIndex = 1;
            for (ScheduledUpdateGroupActionRequest scheduledUpdateGroupActionsListValue : scheduledUpdateGroupActionsList) {
                if (scheduledUpdateGroupActionsListValue.scheduledActionName() != null) {
                    request.addParameter("ScheduledUpdateGroupActions.member." + scheduledUpdateGroupActionsListIndex + ".ScheduledActionName", StringConversion.fromString((String)scheduledUpdateGroupActionsListValue.scheduledActionName()));
                }
                if (scheduledUpdateGroupActionsListValue.startTime() != null) {
                    request.addParameter("ScheduledUpdateGroupActions.member." + scheduledUpdateGroupActionsListIndex + ".StartTime", StringConversion.fromInstant((Instant)scheduledUpdateGroupActionsListValue.startTime()));
                }
                if (scheduledUpdateGroupActionsListValue.endTime() != null) {
                    request.addParameter("ScheduledUpdateGroupActions.member." + scheduledUpdateGroupActionsListIndex + ".EndTime", StringConversion.fromInstant((Instant)scheduledUpdateGroupActionsListValue.endTime()));
                }
                if (scheduledUpdateGroupActionsListValue.recurrence() != null) {
                    request.addParameter("ScheduledUpdateGroupActions.member." + scheduledUpdateGroupActionsListIndex + ".Recurrence", StringConversion.fromString((String)scheduledUpdateGroupActionsListValue.recurrence()));
                }
                if (scheduledUpdateGroupActionsListValue.minSize() != null) {
                    request.addParameter("ScheduledUpdateGroupActions.member." + scheduledUpdateGroupActionsListIndex + ".MinSize", StringConversion.fromInteger((Integer)scheduledUpdateGroupActionsListValue.minSize()));
                }
                if (scheduledUpdateGroupActionsListValue.maxSize() != null) {
                    request.addParameter("ScheduledUpdateGroupActions.member." + scheduledUpdateGroupActionsListIndex + ".MaxSize", StringConversion.fromInteger((Integer)scheduledUpdateGroupActionsListValue.maxSize()));
                }
                if (scheduledUpdateGroupActionsListValue.desiredCapacity() != null) {
                    request.addParameter("ScheduledUpdateGroupActions.member." + scheduledUpdateGroupActionsListIndex + ".DesiredCapacity", StringConversion.fromInteger((Integer)scheduledUpdateGroupActionsListValue.desiredCapacity()));
                }
                ++scheduledUpdateGroupActionsListIndex;
            }
        }
        return request;
    }
}

