/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.autoscaling.model.BlockDeviceMapping;
import software.amazon.awssdk.services.autoscaling.model.CreateLaunchConfigurationRequest;
import software.amazon.awssdk.services.autoscaling.model.Ebs;
import software.amazon.awssdk.services.autoscaling.model.InstanceMonitoring;

public class CreateLaunchConfigurationRequestMarshaller
implements Marshaller<Request<CreateLaunchConfigurationRequest>, CreateLaunchConfigurationRequest> {
    public Request<CreateLaunchConfigurationRequest> marshall(CreateLaunchConfigurationRequest createLaunchConfigurationRequest) {
        if (createLaunchConfigurationRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createLaunchConfigurationRequest, "AutoScalingClient");
        request.addParameter("Action", "CreateLaunchConfiguration");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createLaunchConfigurationRequest.launchConfigurationName() != null) {
            request.addParameter("LaunchConfigurationName", StringConversion.fromString((String)createLaunchConfigurationRequest.launchConfigurationName()));
        }
        if (createLaunchConfigurationRequest.imageId() != null) {
            request.addParameter("ImageId", StringConversion.fromString((String)createLaunchConfigurationRequest.imageId()));
        }
        if (createLaunchConfigurationRequest.keyName() != null) {
            request.addParameter("KeyName", StringConversion.fromString((String)createLaunchConfigurationRequest.keyName()));
        }
        if (createLaunchConfigurationRequest.securityGroups().isEmpty() && !(createLaunchConfigurationRequest.securityGroups() instanceof SdkAutoConstructList)) {
            request.addParameter("SecurityGroups", "");
        } else if (!createLaunchConfigurationRequest.securityGroups().isEmpty() && !(createLaunchConfigurationRequest.securityGroups() instanceof SdkAutoConstructList)) {
            List<String> securityGroupsList = createLaunchConfigurationRequest.securityGroups();
            int securityGroupsListIndex = 1;
            for (String securityGroupsListValue : securityGroupsList) {
                if (securityGroupsListValue != null) {
                    request.addParameter("SecurityGroups.member." + securityGroupsListIndex, StringConversion.fromString((String)securityGroupsListValue));
                }
                ++securityGroupsListIndex;
            }
        }
        if (createLaunchConfigurationRequest.classicLinkVPCId() != null) {
            request.addParameter("ClassicLinkVPCId", StringConversion.fromString((String)createLaunchConfigurationRequest.classicLinkVPCId()));
        }
        if (createLaunchConfigurationRequest.classicLinkVPCSecurityGroups().isEmpty() && !(createLaunchConfigurationRequest.classicLinkVPCSecurityGroups() instanceof SdkAutoConstructList)) {
            request.addParameter("ClassicLinkVPCSecurityGroups", "");
        } else if (!createLaunchConfigurationRequest.classicLinkVPCSecurityGroups().isEmpty() && !(createLaunchConfigurationRequest.classicLinkVPCSecurityGroups() instanceof SdkAutoConstructList)) {
            List<String> classicLinkVPCSecurityGroupsList = createLaunchConfigurationRequest.classicLinkVPCSecurityGroups();
            int classicLinkVPCSecurityGroupsListIndex = 1;
            for (String classicLinkVPCSecurityGroupsListValue : classicLinkVPCSecurityGroupsList) {
                if (classicLinkVPCSecurityGroupsListValue != null) {
                    request.addParameter("ClassicLinkVPCSecurityGroups.member." + classicLinkVPCSecurityGroupsListIndex, StringConversion.fromString((String)classicLinkVPCSecurityGroupsListValue));
                }
                ++classicLinkVPCSecurityGroupsListIndex;
            }
        }
        if (createLaunchConfigurationRequest.userData() != null) {
            request.addParameter("UserData", StringConversion.fromString((String)createLaunchConfigurationRequest.userData()));
        }
        if (createLaunchConfigurationRequest.instanceId() != null) {
            request.addParameter("InstanceId", StringConversion.fromString((String)createLaunchConfigurationRequest.instanceId()));
        }
        if (createLaunchConfigurationRequest.instanceType() != null) {
            request.addParameter("InstanceType", StringConversion.fromString((String)createLaunchConfigurationRequest.instanceType()));
        }
        if (createLaunchConfigurationRequest.kernelId() != null) {
            request.addParameter("KernelId", StringConversion.fromString((String)createLaunchConfigurationRequest.kernelId()));
        }
        if (createLaunchConfigurationRequest.ramdiskId() != null) {
            request.addParameter("RamdiskId", StringConversion.fromString((String)createLaunchConfigurationRequest.ramdiskId()));
        }
        if (createLaunchConfigurationRequest.blockDeviceMappings().isEmpty() && !(createLaunchConfigurationRequest.blockDeviceMappings() instanceof SdkAutoConstructList)) {
            request.addParameter("BlockDeviceMappings", "");
        } else if (!createLaunchConfigurationRequest.blockDeviceMappings().isEmpty() && !(createLaunchConfigurationRequest.blockDeviceMappings() instanceof SdkAutoConstructList)) {
            List<BlockDeviceMapping> blockDeviceMappingsList = createLaunchConfigurationRequest.blockDeviceMappings();
            int blockDeviceMappingsListIndex = 1;
            for (BlockDeviceMapping blockDeviceMappingsListValue : blockDeviceMappingsList) {
                Ebs ebs;
                if (blockDeviceMappingsListValue.virtualName() != null) {
                    request.addParameter("BlockDeviceMappings.member." + blockDeviceMappingsListIndex + ".VirtualName", StringConversion.fromString((String)blockDeviceMappingsListValue.virtualName()));
                }
                if (blockDeviceMappingsListValue.deviceName() != null) {
                    request.addParameter("BlockDeviceMappings.member." + blockDeviceMappingsListIndex + ".DeviceName", StringConversion.fromString((String)blockDeviceMappingsListValue.deviceName()));
                }
                if ((ebs = blockDeviceMappingsListValue.ebs()) != null) {
                    if (ebs.snapshotId() != null) {
                        request.addParameter("BlockDeviceMappings.member." + blockDeviceMappingsListIndex + ".Ebs.SnapshotId", StringConversion.fromString((String)ebs.snapshotId()));
                    }
                    if (ebs.volumeSize() != null) {
                        request.addParameter("BlockDeviceMappings.member." + blockDeviceMappingsListIndex + ".Ebs.VolumeSize", StringConversion.fromInteger((Integer)ebs.volumeSize()));
                    }
                    if (ebs.volumeType() != null) {
                        request.addParameter("BlockDeviceMappings.member." + blockDeviceMappingsListIndex + ".Ebs.VolumeType", StringConversion.fromString((String)ebs.volumeType()));
                    }
                    if (ebs.deleteOnTermination() != null) {
                        request.addParameter("BlockDeviceMappings.member." + blockDeviceMappingsListIndex + ".Ebs.DeleteOnTermination", StringConversion.fromBoolean((Boolean)ebs.deleteOnTermination()));
                    }
                    if (ebs.iops() != null) {
                        request.addParameter("BlockDeviceMappings.member." + blockDeviceMappingsListIndex + ".Ebs.Iops", StringConversion.fromInteger((Integer)ebs.iops()));
                    }
                    if (ebs.encrypted() != null) {
                        request.addParameter("BlockDeviceMappings.member." + blockDeviceMappingsListIndex + ".Ebs.Encrypted", StringConversion.fromBoolean((Boolean)ebs.encrypted()));
                    }
                }
                if (blockDeviceMappingsListValue.noDevice() != null) {
                    request.addParameter("BlockDeviceMappings.member." + blockDeviceMappingsListIndex + ".NoDevice", StringConversion.fromBoolean((Boolean)blockDeviceMappingsListValue.noDevice()));
                }
                ++blockDeviceMappingsListIndex;
            }
        }
        InstanceMonitoring instanceMonitoring = createLaunchConfigurationRequest.instanceMonitoring();
        if (instanceMonitoring != null && instanceMonitoring.enabled() != null) {
            request.addParameter("InstanceMonitoring.Enabled", StringConversion.fromBoolean((Boolean)instanceMonitoring.enabled()));
        }
        if (createLaunchConfigurationRequest.spotPrice() != null) {
            request.addParameter("SpotPrice", StringConversion.fromString((String)createLaunchConfigurationRequest.spotPrice()));
        }
        if (createLaunchConfigurationRequest.iamInstanceProfile() != null) {
            request.addParameter("IamInstanceProfile", StringConversion.fromString((String)createLaunchConfigurationRequest.iamInstanceProfile()));
        }
        if (createLaunchConfigurationRequest.ebsOptimized() != null) {
            request.addParameter("EbsOptimized", StringConversion.fromBoolean((Boolean)createLaunchConfigurationRequest.ebsOptimized()));
        }
        if (createLaunchConfigurationRequest.associatePublicIpAddress() != null) {
            request.addParameter("AssociatePublicIpAddress", StringConversion.fromBoolean((Boolean)createLaunchConfigurationRequest.associatePublicIpAddress()));
        }
        if (createLaunchConfigurationRequest.placementTenancy() != null) {
            request.addParameter("PlacementTenancy", StringConversion.fromString((String)createLaunchConfigurationRequest.placementTenancy()));
        }
        return request;
    }
}

