/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.autoscaling.model.DeleteLifecycleHookRequest;

public class DeleteLifecycleHookRequestMarshaller
implements Marshaller<Request<DeleteLifecycleHookRequest>, DeleteLifecycleHookRequest> {
    public Request<DeleteLifecycleHookRequest> marshall(DeleteLifecycleHookRequest deleteLifecycleHookRequest) {
        if (deleteLifecycleHookRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)deleteLifecycleHookRequest, "AutoScalingClient");
        request.addParameter("Action", "DeleteLifecycleHook");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteLifecycleHookRequest.lifecycleHookName() != null) {
            request.addParameter("LifecycleHookName", StringConversion.fromString((String)deleteLifecycleHookRequest.lifecycleHookName()));
        }
        if (deleteLifecycleHookRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringConversion.fromString((String)deleteLifecycleHookRequest.autoScalingGroupName()));
        }
        return request;
    }
}

