/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingInstancesRequest;

public class DescribeAutoScalingInstancesRequestMarshaller
implements Marshaller<Request<DescribeAutoScalingInstancesRequest>, DescribeAutoScalingInstancesRequest> {
    public Request<DescribeAutoScalingInstancesRequest> marshall(DescribeAutoScalingInstancesRequest describeAutoScalingInstancesRequest) {
        if (describeAutoScalingInstancesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeAutoScalingInstancesRequest, "AutoScalingClient");
        request.addParameter("Action", "DescribeAutoScalingInstances");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeAutoScalingInstancesRequest.instanceIds().isEmpty() && !(describeAutoScalingInstancesRequest.instanceIds() instanceof SdkAutoConstructList)) {
            request.addParameter("InstanceIds", "");
        } else if (!describeAutoScalingInstancesRequest.instanceIds().isEmpty() && !(describeAutoScalingInstancesRequest.instanceIds() instanceof SdkAutoConstructList)) {
            List<String> instanceIdsList = describeAutoScalingInstancesRequest.instanceIds();
            int instanceIdsListIndex = 1;
            for (String instanceIdsListValue : instanceIdsList) {
                if (instanceIdsListValue != null) {
                    request.addParameter("InstanceIds.member." + instanceIdsListIndex, StringConversion.fromString((String)instanceIdsListValue));
                }
                ++instanceIdsListIndex;
            }
        }
        if (describeAutoScalingInstancesRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringConversion.fromInteger((Integer)describeAutoScalingInstancesRequest.maxRecords()));
        }
        if (describeAutoScalingInstancesRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)describeAutoScalingInstancesRequest.nextToken()));
        }
        return request;
    }
}

