/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.autoscaling.model.DescribeLaunchConfigurationsRequest;

public class DescribeLaunchConfigurationsRequestMarshaller
implements Marshaller<Request<DescribeLaunchConfigurationsRequest>, DescribeLaunchConfigurationsRequest> {
    public Request<DescribeLaunchConfigurationsRequest> marshall(DescribeLaunchConfigurationsRequest describeLaunchConfigurationsRequest) {
        if (describeLaunchConfigurationsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeLaunchConfigurationsRequest, "AutoScalingClient");
        request.addParameter("Action", "DescribeLaunchConfigurations");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeLaunchConfigurationsRequest.launchConfigurationNames().isEmpty() && !(describeLaunchConfigurationsRequest.launchConfigurationNames() instanceof SdkAutoConstructList)) {
            request.addParameter("LaunchConfigurationNames", "");
        } else if (!describeLaunchConfigurationsRequest.launchConfigurationNames().isEmpty() && !(describeLaunchConfigurationsRequest.launchConfigurationNames() instanceof SdkAutoConstructList)) {
            List<String> launchConfigurationNamesList = describeLaunchConfigurationsRequest.launchConfigurationNames();
            int launchConfigurationNamesListIndex = 1;
            for (String launchConfigurationNamesListValue : launchConfigurationNamesList) {
                if (launchConfigurationNamesListValue != null) {
                    request.addParameter("LaunchConfigurationNames.member." + launchConfigurationNamesListIndex, StringConversion.fromString((String)launchConfigurationNamesListValue));
                }
                ++launchConfigurationNamesListIndex;
            }
        }
        if (describeLaunchConfigurationsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)describeLaunchConfigurationsRequest.nextToken()));
        }
        if (describeLaunchConfigurationsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringConversion.fromInteger((Integer)describeLaunchConfigurationsRequest.maxRecords()));
        }
        return request;
    }
}

