/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.autoscaling.model.DescribeLifecycleHooksRequest;

public class DescribeLifecycleHooksRequestMarshaller
implements Marshaller<Request<DescribeLifecycleHooksRequest>, DescribeLifecycleHooksRequest> {
    public Request<DescribeLifecycleHooksRequest> marshall(DescribeLifecycleHooksRequest describeLifecycleHooksRequest) {
        if (describeLifecycleHooksRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeLifecycleHooksRequest, "AutoScalingClient");
        request.addParameter("Action", "DescribeLifecycleHooks");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeLifecycleHooksRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringConversion.fromString((String)describeLifecycleHooksRequest.autoScalingGroupName()));
        }
        if (describeLifecycleHooksRequest.lifecycleHookNames().isEmpty() && !(describeLifecycleHooksRequest.lifecycleHookNames() instanceof SdkAutoConstructList)) {
            request.addParameter("LifecycleHookNames", "");
        } else if (!describeLifecycleHooksRequest.lifecycleHookNames().isEmpty() && !(describeLifecycleHooksRequest.lifecycleHookNames() instanceof SdkAutoConstructList)) {
            List<String> lifecycleHookNamesList = describeLifecycleHooksRequest.lifecycleHookNames();
            int lifecycleHookNamesListIndex = 1;
            for (String lifecycleHookNamesListValue : lifecycleHookNamesList) {
                if (lifecycleHookNamesListValue != null) {
                    request.addParameter("LifecycleHookNames.member." + lifecycleHookNamesListIndex, StringConversion.fromString((String)lifecycleHookNamesListValue));
                }
                ++lifecycleHookNamesListIndex;
            }
        }
        return request;
    }
}

