/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.autoscaling.model.DescribePoliciesRequest;

public class DescribePoliciesRequestMarshaller
implements Marshaller<Request<DescribePoliciesRequest>, DescribePoliciesRequest> {
    public Request<DescribePoliciesRequest> marshall(DescribePoliciesRequest describePoliciesRequest) {
        if (describePoliciesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describePoliciesRequest, "AutoScalingClient");
        request.addParameter("Action", "DescribePolicies");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describePoliciesRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringConversion.fromString((String)describePoliciesRequest.autoScalingGroupName()));
        }
        if (describePoliciesRequest.policyNames().isEmpty() && !(describePoliciesRequest.policyNames() instanceof SdkAutoConstructList)) {
            request.addParameter("PolicyNames", "");
        } else if (!describePoliciesRequest.policyNames().isEmpty() && !(describePoliciesRequest.policyNames() instanceof SdkAutoConstructList)) {
            List<String> policyNamesList = describePoliciesRequest.policyNames();
            int policyNamesListIndex = 1;
            for (String policyNamesListValue : policyNamesList) {
                if (policyNamesListValue != null) {
                    request.addParameter("PolicyNames.member." + policyNamesListIndex, StringConversion.fromString((String)policyNamesListValue));
                }
                ++policyNamesListIndex;
            }
        }
        if (describePoliciesRequest.policyTypes().isEmpty() && !(describePoliciesRequest.policyTypes() instanceof SdkAutoConstructList)) {
            request.addParameter("PolicyTypes", "");
        } else if (!describePoliciesRequest.policyTypes().isEmpty() && !(describePoliciesRequest.policyTypes() instanceof SdkAutoConstructList)) {
            List<String> policyTypesList = describePoliciesRequest.policyTypes();
            int policyTypesListIndex = 1;
            for (String policyTypesListValue : policyTypesList) {
                if (policyTypesListValue != null) {
                    request.addParameter("PolicyTypes.member." + policyTypesListIndex, StringConversion.fromString((String)policyTypesListValue));
                }
                ++policyTypesListIndex;
            }
        }
        if (describePoliciesRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)describePoliciesRequest.nextToken()));
        }
        if (describePoliciesRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringConversion.fromInteger((Integer)describePoliciesRequest.maxRecords()));
        }
        return request;
    }
}

