/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.autoscaling.model.DetachLoadBalancerTargetGroupsRequest;

public class DetachLoadBalancerTargetGroupsRequestMarshaller
implements Marshaller<Request<DetachLoadBalancerTargetGroupsRequest>, DetachLoadBalancerTargetGroupsRequest> {
    public Request<DetachLoadBalancerTargetGroupsRequest> marshall(DetachLoadBalancerTargetGroupsRequest detachLoadBalancerTargetGroupsRequest) {
        if (detachLoadBalancerTargetGroupsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)detachLoadBalancerTargetGroupsRequest, "AutoScalingClient");
        request.addParameter("Action", "DetachLoadBalancerTargetGroups");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (detachLoadBalancerTargetGroupsRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringConversion.fromString((String)detachLoadBalancerTargetGroupsRequest.autoScalingGroupName()));
        }
        if (detachLoadBalancerTargetGroupsRequest.targetGroupARNs().isEmpty() && !(detachLoadBalancerTargetGroupsRequest.targetGroupARNs() instanceof SdkAutoConstructList)) {
            request.addParameter("TargetGroupARNs", "");
        } else if (!detachLoadBalancerTargetGroupsRequest.targetGroupARNs().isEmpty() && !(detachLoadBalancerTargetGroupsRequest.targetGroupARNs() instanceof SdkAutoConstructList)) {
            List<String> targetGroupARNsList = detachLoadBalancerTargetGroupsRequest.targetGroupARNs();
            int targetGroupARNsListIndex = 1;
            for (String targetGroupARNsListValue : targetGroupARNsList) {
                if (targetGroupARNsListValue != null) {
                    request.addParameter("TargetGroupARNs.member." + targetGroupARNsListIndex, StringConversion.fromString((String)targetGroupARNsListValue));
                }
                ++targetGroupARNsListIndex;
            }
        }
        return request;
    }
}

