/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.autoscaling.model.NotificationConfiguration;

public class NotificationConfigurationUnmarshaller
implements Unmarshaller<NotificationConfiguration, StaxUnmarshallerContext> {
    private static final NotificationConfigurationUnmarshaller INSTANCE = new NotificationConfigurationUnmarshaller();

    public NotificationConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        NotificationConfiguration.Builder notificationConfiguration = NotificationConfiguration.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("AutoScalingGroupName", targetDepth)) {
                    notificationConfiguration.autoScalingGroupName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("TopicARN", targetDepth)) {
                    notificationConfiguration.topicARN(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("NotificationType", targetDepth)) continue;
                notificationConfiguration.notificationType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (NotificationConfiguration)notificationConfiguration.build();
    }

    public static NotificationConfigurationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

