/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.time.Instant;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.autoscaling.model.PutScheduledUpdateGroupActionRequest;

public class PutScheduledUpdateGroupActionRequestMarshaller
implements Marshaller<Request<PutScheduledUpdateGroupActionRequest>, PutScheduledUpdateGroupActionRequest> {
    public Request<PutScheduledUpdateGroupActionRequest> marshall(PutScheduledUpdateGroupActionRequest putScheduledUpdateGroupActionRequest) {
        if (putScheduledUpdateGroupActionRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)putScheduledUpdateGroupActionRequest, "AutoScalingClient");
        request.addParameter("Action", "PutScheduledUpdateGroupAction");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (putScheduledUpdateGroupActionRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringConversion.fromString((String)putScheduledUpdateGroupActionRequest.autoScalingGroupName()));
        }
        if (putScheduledUpdateGroupActionRequest.scheduledActionName() != null) {
            request.addParameter("ScheduledActionName", StringConversion.fromString((String)putScheduledUpdateGroupActionRequest.scheduledActionName()));
        }
        if (putScheduledUpdateGroupActionRequest.time() != null) {
            request.addParameter("Time", StringConversion.fromInstant((Instant)putScheduledUpdateGroupActionRequest.time()));
        }
        if (putScheduledUpdateGroupActionRequest.startTime() != null) {
            request.addParameter("StartTime", StringConversion.fromInstant((Instant)putScheduledUpdateGroupActionRequest.startTime()));
        }
        if (putScheduledUpdateGroupActionRequest.endTime() != null) {
            request.addParameter("EndTime", StringConversion.fromInstant((Instant)putScheduledUpdateGroupActionRequest.endTime()));
        }
        if (putScheduledUpdateGroupActionRequest.recurrence() != null) {
            request.addParameter("Recurrence", StringConversion.fromString((String)putScheduledUpdateGroupActionRequest.recurrence()));
        }
        if (putScheduledUpdateGroupActionRequest.minSize() != null) {
            request.addParameter("MinSize", StringConversion.fromInteger((Integer)putScheduledUpdateGroupActionRequest.minSize()));
        }
        if (putScheduledUpdateGroupActionRequest.maxSize() != null) {
            request.addParameter("MaxSize", StringConversion.fromInteger((Integer)putScheduledUpdateGroupActionRequest.maxSize()));
        }
        if (putScheduledUpdateGroupActionRequest.desiredCapacity() != null) {
            request.addParameter("DesiredCapacity", StringConversion.fromInteger((Integer)putScheduledUpdateGroupActionRequest.desiredCapacity()));
        }
        return request;
    }
}

