/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.autoscaling.model.RecordLifecycleActionHeartbeatRequest;

public class RecordLifecycleActionHeartbeatRequestMarshaller
implements Marshaller<Request<RecordLifecycleActionHeartbeatRequest>, RecordLifecycleActionHeartbeatRequest> {
    public Request<RecordLifecycleActionHeartbeatRequest> marshall(RecordLifecycleActionHeartbeatRequest recordLifecycleActionHeartbeatRequest) {
        if (recordLifecycleActionHeartbeatRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)recordLifecycleActionHeartbeatRequest, "AutoScalingClient");
        request.addParameter("Action", "RecordLifecycleActionHeartbeat");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (recordLifecycleActionHeartbeatRequest.lifecycleHookName() != null) {
            request.addParameter("LifecycleHookName", StringConversion.fromString((String)recordLifecycleActionHeartbeatRequest.lifecycleHookName()));
        }
        if (recordLifecycleActionHeartbeatRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringConversion.fromString((String)recordLifecycleActionHeartbeatRequest.autoScalingGroupName()));
        }
        if (recordLifecycleActionHeartbeatRequest.lifecycleActionToken() != null) {
            request.addParameter("LifecycleActionToken", StringConversion.fromString((String)recordLifecycleActionHeartbeatRequest.lifecycleActionToken()));
        }
        if (recordLifecycleActionHeartbeatRequest.instanceId() != null) {
            request.addParameter("InstanceId", StringConversion.fromString((String)recordLifecycleActionHeartbeatRequest.instanceId()));
        }
        return request;
    }
}

