/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.autoscaling.model.SetDesiredCapacityRequest;

public class SetDesiredCapacityRequestMarshaller
implements Marshaller<Request<SetDesiredCapacityRequest>, SetDesiredCapacityRequest> {
    public Request<SetDesiredCapacityRequest> marshall(SetDesiredCapacityRequest setDesiredCapacityRequest) {
        if (setDesiredCapacityRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)setDesiredCapacityRequest, "AutoScalingClient");
        request.addParameter("Action", "SetDesiredCapacity");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (setDesiredCapacityRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringConversion.fromString((String)setDesiredCapacityRequest.autoScalingGroupName()));
        }
        if (setDesiredCapacityRequest.desiredCapacity() != null) {
            request.addParameter("DesiredCapacity", StringConversion.fromInteger((Integer)setDesiredCapacityRequest.desiredCapacity()));
        }
        if (setDesiredCapacityRequest.honorCooldown() != null) {
            request.addParameter("HonorCooldown", StringConversion.fromBoolean((Boolean)setDesiredCapacityRequest.honorCooldown()));
        }
        return request;
    }
}

