/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.autoscaling.model.LaunchTemplateSpecification;
import software.amazon.awssdk.services.autoscaling.model.UpdateAutoScalingGroupRequest;

public class UpdateAutoScalingGroupRequestMarshaller
implements Marshaller<Request<UpdateAutoScalingGroupRequest>, UpdateAutoScalingGroupRequest> {
    public Request<UpdateAutoScalingGroupRequest> marshall(UpdateAutoScalingGroupRequest updateAutoScalingGroupRequest) {
        LaunchTemplateSpecification launchTemplate;
        if (updateAutoScalingGroupRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)updateAutoScalingGroupRequest, "AutoScalingClient");
        request.addParameter("Action", "UpdateAutoScalingGroup");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateAutoScalingGroupRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringConversion.fromString((String)updateAutoScalingGroupRequest.autoScalingGroupName()));
        }
        if (updateAutoScalingGroupRequest.launchConfigurationName() != null) {
            request.addParameter("LaunchConfigurationName", StringConversion.fromString((String)updateAutoScalingGroupRequest.launchConfigurationName()));
        }
        if ((launchTemplate = updateAutoScalingGroupRequest.launchTemplate()) != null) {
            if (launchTemplate.launchTemplateId() != null) {
                request.addParameter("LaunchTemplate.LaunchTemplateId", StringConversion.fromString((String)launchTemplate.launchTemplateId()));
            }
            if (launchTemplate.launchTemplateName() != null) {
                request.addParameter("LaunchTemplate.LaunchTemplateName", StringConversion.fromString((String)launchTemplate.launchTemplateName()));
            }
            if (launchTemplate.version() != null) {
                request.addParameter("LaunchTemplate.Version", StringConversion.fromString((String)launchTemplate.version()));
            }
        }
        if (updateAutoScalingGroupRequest.minSize() != null) {
            request.addParameter("MinSize", StringConversion.fromInteger((Integer)updateAutoScalingGroupRequest.minSize()));
        }
        if (updateAutoScalingGroupRequest.maxSize() != null) {
            request.addParameter("MaxSize", StringConversion.fromInteger((Integer)updateAutoScalingGroupRequest.maxSize()));
        }
        if (updateAutoScalingGroupRequest.desiredCapacity() != null) {
            request.addParameter("DesiredCapacity", StringConversion.fromInteger((Integer)updateAutoScalingGroupRequest.desiredCapacity()));
        }
        if (updateAutoScalingGroupRequest.defaultCooldown() != null) {
            request.addParameter("DefaultCooldown", StringConversion.fromInteger((Integer)updateAutoScalingGroupRequest.defaultCooldown()));
        }
        if (updateAutoScalingGroupRequest.availabilityZones().isEmpty() && !(updateAutoScalingGroupRequest.availabilityZones() instanceof SdkAutoConstructList)) {
            request.addParameter("AvailabilityZones", "");
        } else if (!updateAutoScalingGroupRequest.availabilityZones().isEmpty() && !(updateAutoScalingGroupRequest.availabilityZones() instanceof SdkAutoConstructList)) {
            List<String> availabilityZonesList = updateAutoScalingGroupRequest.availabilityZones();
            int availabilityZonesListIndex = 1;
            for (String availabilityZonesListValue : availabilityZonesList) {
                if (availabilityZonesListValue != null) {
                    request.addParameter("AvailabilityZones.member." + availabilityZonesListIndex, StringConversion.fromString((String)availabilityZonesListValue));
                }
                ++availabilityZonesListIndex;
            }
        }
        if (updateAutoScalingGroupRequest.healthCheckType() != null) {
            request.addParameter("HealthCheckType", StringConversion.fromString((String)updateAutoScalingGroupRequest.healthCheckType()));
        }
        if (updateAutoScalingGroupRequest.healthCheckGracePeriod() != null) {
            request.addParameter("HealthCheckGracePeriod", StringConversion.fromInteger((Integer)updateAutoScalingGroupRequest.healthCheckGracePeriod()));
        }
        if (updateAutoScalingGroupRequest.placementGroup() != null) {
            request.addParameter("PlacementGroup", StringConversion.fromString((String)updateAutoScalingGroupRequest.placementGroup()));
        }
        if (updateAutoScalingGroupRequest.vpcZoneIdentifier() != null) {
            request.addParameter("VPCZoneIdentifier", StringConversion.fromString((String)updateAutoScalingGroupRequest.vpcZoneIdentifier()));
        }
        if (updateAutoScalingGroupRequest.terminationPolicies().isEmpty() && !(updateAutoScalingGroupRequest.terminationPolicies() instanceof SdkAutoConstructList)) {
            request.addParameter("TerminationPolicies", "");
        } else if (!updateAutoScalingGroupRequest.terminationPolicies().isEmpty() && !(updateAutoScalingGroupRequest.terminationPolicies() instanceof SdkAutoConstructList)) {
            List<String> terminationPoliciesList = updateAutoScalingGroupRequest.terminationPolicies();
            int terminationPoliciesListIndex = 1;
            for (String terminationPoliciesListValue : terminationPoliciesList) {
                if (terminationPoliciesListValue != null) {
                    request.addParameter("TerminationPolicies.member." + terminationPoliciesListIndex, StringConversion.fromString((String)terminationPoliciesListValue));
                }
                ++terminationPoliciesListIndex;
            }
        }
        if (updateAutoScalingGroupRequest.newInstancesProtectedFromScaleIn() != null) {
            request.addParameter("NewInstancesProtectedFromScaleIn", StringConversion.fromBoolean((Boolean)updateAutoScalingGroupRequest.newInstancesProtectedFromScaleIn()));
        }
        if (updateAutoScalingGroupRequest.serviceLinkedRoleARN() != null) {
            request.addParameter("ServiceLinkedRoleARN", StringConversion.fromString((String)updateAutoScalingGroupRequest.serviceLinkedRoleARN()));
        }
        return request;
    }
}

