/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configures a predefined metric for a target tracking policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PredefinedMetricSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<PredefinedMetricSpecification.Builder, PredefinedMetricSpecification> {
    private static final SdkField<String> PREDEFINED_METRIC_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PredefinedMetricSpecification::predefinedMetricTypeAsString))
            .setter(setter(Builder::predefinedMetricType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredefinedMetricType").build())
            .build();

    private static final SdkField<String> RESOURCE_LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PredefinedMetricSpecification::resourceLabel)).setter(setter(Builder::resourceLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceLabel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREDEFINED_METRIC_TYPE_FIELD,
            RESOURCE_LABEL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String predefinedMetricType;

    private final String resourceLabel;

    private PredefinedMetricSpecification(BuilderImpl builder) {
        this.predefinedMetricType = builder.predefinedMetricType;
        this.resourceLabel = builder.resourceLabel;
    }

    /**
     * <p>
     * The metric type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #predefinedMetricType} will return {@link MetricType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #predefinedMetricTypeAsString}.
     * </p>
     * 
     * @return The metric type.
     * @see MetricType
     */
    public MetricType predefinedMetricType() {
        return MetricType.fromValue(predefinedMetricType);
    }

    /**
     * <p>
     * The metric type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #predefinedMetricType} will return {@link MetricType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #predefinedMetricTypeAsString}.
     * </p>
     * 
     * @return The metric type.
     * @see MetricType
     */
    public String predefinedMetricTypeAsString() {
        return predefinedMetricType;
    }

    /**
     * <p>
     * Identifies the resource associated with the metric type. The following predefined metrics are available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ASGAverageCPUUtilization</code> - average CPU utilization of the Auto Scaling group
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ASGAverageNetworkIn</code> - average number of bytes received on all network interfaces by the Auto Scaling
     * group
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ASGAverageNetworkOut</code> - average number of bytes sent out on all network interfaces by the Auto
     * Scaling group
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ALBRequestCountPerTarget</code> - number of requests completed per target in an Application Load Balancer
     * target group
     * </p>
     * </li>
     * </ul>
     * <p>
     * For predefined metric types <code>ASGAverageCPUUtilization</code>, <code>ASGAverageNetworkIn</code>, and
     * <code>ASGAverageNetworkOut</code>, the parameter must not be specified as the resource associated with the metric
     * type is the Auto Scaling group. For predefined metric type <code>ALBRequestCountPerTarget</code>, the parameter
     * must be specified in the format:
     * <code>app/<i>load-balancer-name</i>/<i>load-balancer-id</i>/targetgroup/<i>target-group-name</i>/<i>target-group-id</i> </code>
     * , where <code>app/<i>load-balancer-name</i>/<i>load-balancer-id</i> </code> is the final portion of the load
     * balancer ARN, and <code>targetgroup/<i>target-group-name</i>/<i>target-group-id</i> </code> is the final portion
     * of the target group ARN. The target group must be attached to the Auto Scaling group.
     * </p>
     * 
     * @return Identifies the resource associated with the metric type. The following predefined metrics are
     *         available:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ASGAverageCPUUtilization</code> - average CPU utilization of the Auto Scaling group
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ASGAverageNetworkIn</code> - average number of bytes received on all network interfaces by the Auto
     *         Scaling group
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ASGAverageNetworkOut</code> - average number of bytes sent out on all network interfaces by the
     *         Auto Scaling group
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ALBRequestCountPerTarget</code> - number of requests completed per target in an Application Load
     *         Balancer target group
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For predefined metric types <code>ASGAverageCPUUtilization</code>, <code>ASGAverageNetworkIn</code>, and
     *         <code>ASGAverageNetworkOut</code>, the parameter must not be specified as the resource associated with
     *         the metric type is the Auto Scaling group. For predefined metric type
     *         <code>ALBRequestCountPerTarget</code>, the parameter must be specified in the format:
     *         <code>app/<i>load-balancer-name</i>/<i>load-balancer-id</i>/targetgroup/<i>target-group-name</i>/<i>target-group-id</i> </code>
     *         , where <code>app/<i>load-balancer-name</i>/<i>load-balancer-id</i> </code> is the final portion of the
     *         load balancer ARN, and <code>targetgroup/<i>target-group-name</i>/<i>target-group-id</i> </code> is the
     *         final portion of the target group ARN. The target group must be attached to the Auto Scaling group.
     */
    public String resourceLabel() {
        return resourceLabel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(predefinedMetricTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceLabel());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PredefinedMetricSpecification)) {
            return false;
        }
        PredefinedMetricSpecification other = (PredefinedMetricSpecification) obj;
        return Objects.equals(predefinedMetricTypeAsString(), other.predefinedMetricTypeAsString())
                && Objects.equals(resourceLabel(), other.resourceLabel());
    }

    @Override
    public String toString() {
        return ToString.builder("PredefinedMetricSpecification").add("PredefinedMetricType", predefinedMetricTypeAsString())
                .add("ResourceLabel", resourceLabel()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PredefinedMetricType":
            return Optional.ofNullable(clazz.cast(predefinedMetricTypeAsString()));
        case "ResourceLabel":
            return Optional.ofNullable(clazz.cast(resourceLabel()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PredefinedMetricSpecification, T> g) {
        return obj -> g.apply((PredefinedMetricSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PredefinedMetricSpecification> {
        /**
         * <p>
         * The metric type.
         * </p>
         * 
         * @param predefinedMetricType
         *        The metric type.
         * @see MetricType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricType
         */
        Builder predefinedMetricType(String predefinedMetricType);

        /**
         * <p>
         * The metric type.
         * </p>
         * 
         * @param predefinedMetricType
         *        The metric type.
         * @see MetricType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetricType
         */
        Builder predefinedMetricType(MetricType predefinedMetricType);

        /**
         * <p>
         * Identifies the resource associated with the metric type. The following predefined metrics are available:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ASGAverageCPUUtilization</code> - average CPU utilization of the Auto Scaling group
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ASGAverageNetworkIn</code> - average number of bytes received on all network interfaces by the Auto
         * Scaling group
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ASGAverageNetworkOut</code> - average number of bytes sent out on all network interfaces by the Auto
         * Scaling group
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ALBRequestCountPerTarget</code> - number of requests completed per target in an Application Load
         * Balancer target group
         * </p>
         * </li>
         * </ul>
         * <p>
         * For predefined metric types <code>ASGAverageCPUUtilization</code>, <code>ASGAverageNetworkIn</code>, and
         * <code>ASGAverageNetworkOut</code>, the parameter must not be specified as the resource associated with the
         * metric type is the Auto Scaling group. For predefined metric type <code>ALBRequestCountPerTarget</code>, the
         * parameter must be specified in the format:
         * <code>app/<i>load-balancer-name</i>/<i>load-balancer-id</i>/targetgroup/<i>target-group-name</i>/<i>target-group-id</i> </code>
         * , where <code>app/<i>load-balancer-name</i>/<i>load-balancer-id</i> </code> is the final portion of the load
         * balancer ARN, and <code>targetgroup/<i>target-group-name</i>/<i>target-group-id</i> </code> is the final
         * portion of the target group ARN. The target group must be attached to the Auto Scaling group.
         * </p>
         * 
         * @param resourceLabel
         *        Identifies the resource associated with the metric type. The following predefined metrics are
         *        available:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ASGAverageCPUUtilization</code> - average CPU utilization of the Auto Scaling group
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ASGAverageNetworkIn</code> - average number of bytes received on all network interfaces by the
         *        Auto Scaling group
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ASGAverageNetworkOut</code> - average number of bytes sent out on all network interfaces by the
         *        Auto Scaling group
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ALBRequestCountPerTarget</code> - number of requests completed per target in an Application Load
         *        Balancer target group
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For predefined metric types <code>ASGAverageCPUUtilization</code>, <code>ASGAverageNetworkIn</code>,
         *        and <code>ASGAverageNetworkOut</code>, the parameter must not be specified as the resource associated
         *        with the metric type is the Auto Scaling group. For predefined metric type
         *        <code>ALBRequestCountPerTarget</code>, the parameter must be specified in the format:
         *        <code>app/<i>load-balancer-name</i>/<i>load-balancer-id</i>/targetgroup/<i>target-group-name</i>/<i>target-group-id</i> </code>
         *        , where <code>app/<i>load-balancer-name</i>/<i>load-balancer-id</i> </code> is the final portion of
         *        the load balancer ARN, and <code>targetgroup/<i>target-group-name</i>/<i>target-group-id</i> </code>
         *        is the final portion of the target group ARN. The target group must be attached to the Auto Scaling
         *        group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceLabel(String resourceLabel);
    }

    static final class BuilderImpl implements Builder {
        private String predefinedMetricType;

        private String resourceLabel;

        private BuilderImpl() {
        }

        private BuilderImpl(PredefinedMetricSpecification model) {
            predefinedMetricType(model.predefinedMetricType);
            resourceLabel(model.resourceLabel);
        }

        public final String getPredefinedMetricType() {
            return predefinedMetricType;
        }

        @Override
        public final Builder predefinedMetricType(String predefinedMetricType) {
            this.predefinedMetricType = predefinedMetricType;
            return this;
        }

        @Override
        public final Builder predefinedMetricType(MetricType predefinedMetricType) {
            this.predefinedMetricType(predefinedMetricType.toString());
            return this;
        }

        public final void setPredefinedMetricType(String predefinedMetricType) {
            this.predefinedMetricType = predefinedMetricType;
        }

        public final String getResourceLabel() {
            return resourceLabel;
        }

        @Override
        public final Builder resourceLabel(String resourceLabel) {
            this.resourceLabel = resourceLabel;
            return this;
        }

        public final void setResourceLabel(String resourceLabel) {
            this.resourceLabel = resourceLabel;
        }

        @Override
        public PredefinedMetricSpecification build() {
            return new PredefinedMetricSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
