/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SuspendProcessesRequest extends AutoScalingRequest implements
        ToCopyableBuilder<SuspendProcessesRequest.Builder, SuspendProcessesRequest> {
    private static final SdkField<String> AUTO_SCALING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SuspendProcessesRequest::autoScalingGroupName)).setter(setter(Builder::autoScalingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupName").build())
            .build();

    private static final SdkField<List<String>> SCALING_PROCESSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(SuspendProcessesRequest::scalingProcesses))
            .setter(setter(Builder::scalingProcesses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingProcesses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_GROUP_NAME_FIELD,
            SCALING_PROCESSES_FIELD));

    private final String autoScalingGroupName;

    private final List<String> scalingProcesses;

    private SuspendProcessesRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.scalingProcesses = builder.scalingProcesses;
    }

    /**
     * <p>
     * The name of the Auto Scaling group.
     * </p>
     * 
     * @return The name of the Auto Scaling group.
     */
    public String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * <p>
     * One or more of the following processes. If you omit this parameter, all processes are specified.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Launch</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Terminate</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HealthCheck</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ReplaceUnhealthy</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AZRebalance</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AlarmNotification</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ScheduledActions</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AddToLoadBalancer</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more of the following processes. If you omit this parameter, all processes are specified.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Launch</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Terminate</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>HealthCheck</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ReplaceUnhealthy</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AZRebalance</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AlarmNotification</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ScheduledActions</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AddToLoadBalancer</code>
     *         </p>
     *         </li>
     */
    public List<String> scalingProcesses() {
        return scalingProcesses;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(scalingProcesses());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuspendProcessesRequest)) {
            return false;
        }
        SuspendProcessesRequest other = (SuspendProcessesRequest) obj;
        return Objects.equals(autoScalingGroupName(), other.autoScalingGroupName())
                && Objects.equals(scalingProcesses(), other.scalingProcesses());
    }

    @Override
    public String toString() {
        return ToString.builder("SuspendProcessesRequest").add("AutoScalingGroupName", autoScalingGroupName())
                .add("ScalingProcesses", scalingProcesses()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoScalingGroupName":
            return Optional.ofNullable(clazz.cast(autoScalingGroupName()));
        case "ScalingProcesses":
            return Optional.ofNullable(clazz.cast(scalingProcesses()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SuspendProcessesRequest, T> g) {
        return obj -> g.apply((SuspendProcessesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AutoScalingRequest.Builder, SdkPojo, CopyableBuilder<Builder, SuspendProcessesRequest> {
        /**
         * <p>
         * The name of the Auto Scaling group.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name of the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * One or more of the following processes. If you omit this parameter, all processes are specified.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Launch</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Terminate</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HealthCheck</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ReplaceUnhealthy</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AZRebalance</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AlarmNotification</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ScheduledActions</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AddToLoadBalancer</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param scalingProcesses
         *        One or more of the following processes. If you omit this parameter, all processes are specified.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Launch</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Terminate</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HealthCheck</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ReplaceUnhealthy</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AZRebalance</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AlarmNotification</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ScheduledActions</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AddToLoadBalancer</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingProcesses(Collection<String> scalingProcesses);

        /**
         * <p>
         * One or more of the following processes. If you omit this parameter, all processes are specified.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Launch</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Terminate</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HealthCheck</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ReplaceUnhealthy</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AZRebalance</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AlarmNotification</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ScheduledActions</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AddToLoadBalancer</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param scalingProcesses
         *        One or more of the following processes. If you omit this parameter, all processes are specified.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Launch</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Terminate</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HealthCheck</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ReplaceUnhealthy</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AZRebalance</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AlarmNotification</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ScheduledActions</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AddToLoadBalancer</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingProcesses(String... scalingProcesses);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AutoScalingRequest.BuilderImpl implements Builder {
        private String autoScalingGroupName;

        private List<String> scalingProcesses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SuspendProcessesRequest model) {
            super(model);
            autoScalingGroupName(model.autoScalingGroupName);
            scalingProcesses(model.scalingProcesses);
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final Collection<String> getScalingProcesses() {
            return scalingProcesses;
        }

        @Override
        public final Builder scalingProcesses(Collection<String> scalingProcesses) {
            this.scalingProcesses = ProcessNamesCopier.copy(scalingProcesses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalingProcesses(String... scalingProcesses) {
            scalingProcesses(Arrays.asList(scalingProcesses));
            return this;
        }

        public final void setScalingProcesses(Collection<String> scalingProcesses) {
            this.scalingProcesses = ProcessNamesCopier.copy(scalingProcesses);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SuspendProcessesRequest build() {
            return new SuspendProcessesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
