/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingRequest;
import software.amazon.awssdk.services.autoscaling.model.AvailabilityZonesCopier;
import software.amazon.awssdk.services.autoscaling.model.LaunchTemplateSpecification;
import software.amazon.awssdk.services.autoscaling.model.TerminationPoliciesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAutoScalingGroupRequest
extends AutoScalingRequest
implements ToCopyableBuilder<Builder, UpdateAutoScalingGroupRequest> {
    private static final SdkField<String> AUTO_SCALING_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateAutoScalingGroupRequest.getter(UpdateAutoScalingGroupRequest::autoScalingGroupName)).setter(UpdateAutoScalingGroupRequest.setter(Builder::autoScalingGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingGroupName").build()}).build();
    private static final SdkField<String> LAUNCH_CONFIGURATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateAutoScalingGroupRequest.getter(UpdateAutoScalingGroupRequest::launchConfigurationName)).setter(UpdateAutoScalingGroupRequest.setter(Builder::launchConfigurationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchConfigurationName").build()}).build();
    private static final SdkField<LaunchTemplateSpecification> LAUNCH_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(UpdateAutoScalingGroupRequest.getter(UpdateAutoScalingGroupRequest::launchTemplate)).setter(UpdateAutoScalingGroupRequest.setter(Builder::launchTemplate)).constructor(LaunchTemplateSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplate").build()}).build();
    private static final SdkField<Integer> MIN_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(UpdateAutoScalingGroupRequest.getter(UpdateAutoScalingGroupRequest::minSize)).setter(UpdateAutoScalingGroupRequest.setter(Builder::minSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinSize").build()}).build();
    private static final SdkField<Integer> MAX_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(UpdateAutoScalingGroupRequest.getter(UpdateAutoScalingGroupRequest::maxSize)).setter(UpdateAutoScalingGroupRequest.setter(Builder::maxSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxSize").build()}).build();
    private static final SdkField<Integer> DESIRED_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(UpdateAutoScalingGroupRequest.getter(UpdateAutoScalingGroupRequest::desiredCapacity)).setter(UpdateAutoScalingGroupRequest.setter(Builder::desiredCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredCapacity").build()}).build();
    private static final SdkField<Integer> DEFAULT_COOLDOWN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(UpdateAutoScalingGroupRequest.getter(UpdateAutoScalingGroupRequest::defaultCooldown)).setter(UpdateAutoScalingGroupRequest.setter(Builder::defaultCooldown)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultCooldown").build()}).build();
    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateAutoScalingGroupRequest.getter(UpdateAutoScalingGroupRequest::availabilityZones)).setter(UpdateAutoScalingGroupRequest.setter(Builder::availabilityZones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZones").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> HEALTH_CHECK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateAutoScalingGroupRequest.getter(UpdateAutoScalingGroupRequest::healthCheckType)).setter(UpdateAutoScalingGroupRequest.setter(Builder::healthCheckType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckType").build()}).build();
    private static final SdkField<Integer> HEALTH_CHECK_GRACE_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(UpdateAutoScalingGroupRequest.getter(UpdateAutoScalingGroupRequest::healthCheckGracePeriod)).setter(UpdateAutoScalingGroupRequest.setter(Builder::healthCheckGracePeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckGracePeriod").build()}).build();
    private static final SdkField<String> PLACEMENT_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateAutoScalingGroupRequest.getter(UpdateAutoScalingGroupRequest::placementGroup)).setter(UpdateAutoScalingGroupRequest.setter(Builder::placementGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlacementGroup").build()}).build();
    private static final SdkField<String> VPC_ZONE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateAutoScalingGroupRequest.getter(UpdateAutoScalingGroupRequest::vpcZoneIdentifier)).setter(UpdateAutoScalingGroupRequest.setter(Builder::vpcZoneIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VPCZoneIdentifier").build()}).build();
    private static final SdkField<List<String>> TERMINATION_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateAutoScalingGroupRequest.getter(UpdateAutoScalingGroupRequest::terminationPolicies)).setter(UpdateAutoScalingGroupRequest.setter(Builder::terminationPolicies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminationPolicies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> NEW_INSTANCES_PROTECTED_FROM_SCALE_IN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(UpdateAutoScalingGroupRequest.getter(UpdateAutoScalingGroupRequest::newInstancesProtectedFromScaleIn)).setter(UpdateAutoScalingGroupRequest.setter(Builder::newInstancesProtectedFromScaleIn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewInstancesProtectedFromScaleIn").build()}).build();
    private static final SdkField<String> SERVICE_LINKED_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateAutoScalingGroupRequest.getter(UpdateAutoScalingGroupRequest::serviceLinkedRoleARN)).setter(UpdateAutoScalingGroupRequest.setter(Builder::serviceLinkedRoleARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceLinkedRoleARN").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_SCALING_GROUP_NAME_FIELD, LAUNCH_CONFIGURATION_NAME_FIELD, LAUNCH_TEMPLATE_FIELD, MIN_SIZE_FIELD, MAX_SIZE_FIELD, DESIRED_CAPACITY_FIELD, DEFAULT_COOLDOWN_FIELD, AVAILABILITY_ZONES_FIELD, HEALTH_CHECK_TYPE_FIELD, HEALTH_CHECK_GRACE_PERIOD_FIELD, PLACEMENT_GROUP_FIELD, VPC_ZONE_IDENTIFIER_FIELD, TERMINATION_POLICIES_FIELD, NEW_INSTANCES_PROTECTED_FROM_SCALE_IN_FIELD, SERVICE_LINKED_ROLE_ARN_FIELD));
    private final String autoScalingGroupName;
    private final String launchConfigurationName;
    private final LaunchTemplateSpecification launchTemplate;
    private final Integer minSize;
    private final Integer maxSize;
    private final Integer desiredCapacity;
    private final Integer defaultCooldown;
    private final List<String> availabilityZones;
    private final String healthCheckType;
    private final Integer healthCheckGracePeriod;
    private final String placementGroup;
    private final String vpcZoneIdentifier;
    private final List<String> terminationPolicies;
    private final Boolean newInstancesProtectedFromScaleIn;
    private final String serviceLinkedRoleARN;

    private UpdateAutoScalingGroupRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.launchConfigurationName = builder.launchConfigurationName;
        this.launchTemplate = builder.launchTemplate;
        this.minSize = builder.minSize;
        this.maxSize = builder.maxSize;
        this.desiredCapacity = builder.desiredCapacity;
        this.defaultCooldown = builder.defaultCooldown;
        this.availabilityZones = builder.availabilityZones;
        this.healthCheckType = builder.healthCheckType;
        this.healthCheckGracePeriod = builder.healthCheckGracePeriod;
        this.placementGroup = builder.placementGroup;
        this.vpcZoneIdentifier = builder.vpcZoneIdentifier;
        this.terminationPolicies = builder.terminationPolicies;
        this.newInstancesProtectedFromScaleIn = builder.newInstancesProtectedFromScaleIn;
        this.serviceLinkedRoleARN = builder.serviceLinkedRoleARN;
    }

    public String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public String launchConfigurationName() {
        return this.launchConfigurationName;
    }

    public LaunchTemplateSpecification launchTemplate() {
        return this.launchTemplate;
    }

    public Integer minSize() {
        return this.minSize;
    }

    public Integer maxSize() {
        return this.maxSize;
    }

    public Integer desiredCapacity() {
        return this.desiredCapacity;
    }

    public Integer defaultCooldown() {
        return this.defaultCooldown;
    }

    public List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public String healthCheckType() {
        return this.healthCheckType;
    }

    public Integer healthCheckGracePeriod() {
        return this.healthCheckGracePeriod;
    }

    public String placementGroup() {
        return this.placementGroup;
    }

    public String vpcZoneIdentifier() {
        return this.vpcZoneIdentifier;
    }

    public List<String> terminationPolicies() {
        return this.terminationPolicies;
    }

    public Boolean newInstancesProtectedFromScaleIn() {
        return this.newInstancesProtectedFromScaleIn;
    }

    public String serviceLinkedRoleARN() {
        return this.serviceLinkedRoleARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.minSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.desiredCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultCooldown());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZones());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckType());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheckGracePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.placementGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcZoneIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.terminationPolicies());
        hashCode = 31 * hashCode + Objects.hashCode(this.newInstancesProtectedFromScaleIn());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceLinkedRoleARN());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAutoScalingGroupRequest)) {
            return false;
        }
        UpdateAutoScalingGroupRequest other = (UpdateAutoScalingGroupRequest)((Object)obj);
        return Objects.equals(this.autoScalingGroupName(), other.autoScalingGroupName()) && Objects.equals(this.launchConfigurationName(), other.launchConfigurationName()) && Objects.equals(this.launchTemplate(), other.launchTemplate()) && Objects.equals(this.minSize(), other.minSize()) && Objects.equals(this.maxSize(), other.maxSize()) && Objects.equals(this.desiredCapacity(), other.desiredCapacity()) && Objects.equals(this.defaultCooldown(), other.defaultCooldown()) && Objects.equals(this.availabilityZones(), other.availabilityZones()) && Objects.equals(this.healthCheckType(), other.healthCheckType()) && Objects.equals(this.healthCheckGracePeriod(), other.healthCheckGracePeriod()) && Objects.equals(this.placementGroup(), other.placementGroup()) && Objects.equals(this.vpcZoneIdentifier(), other.vpcZoneIdentifier()) && Objects.equals(this.terminationPolicies(), other.terminationPolicies()) && Objects.equals(this.newInstancesProtectedFromScaleIn(), other.newInstancesProtectedFromScaleIn()) && Objects.equals(this.serviceLinkedRoleARN(), other.serviceLinkedRoleARN());
    }

    public String toString() {
        return ToString.builder((String)"UpdateAutoScalingGroupRequest").add("AutoScalingGroupName", (Object)this.autoScalingGroupName()).add("LaunchConfigurationName", (Object)this.launchConfigurationName()).add("LaunchTemplate", (Object)this.launchTemplate()).add("MinSize", (Object)this.minSize()).add("MaxSize", (Object)this.maxSize()).add("DesiredCapacity", (Object)this.desiredCapacity()).add("DefaultCooldown", (Object)this.defaultCooldown()).add("AvailabilityZones", this.availabilityZones()).add("HealthCheckType", (Object)this.healthCheckType()).add("HealthCheckGracePeriod", (Object)this.healthCheckGracePeriod()).add("PlacementGroup", (Object)this.placementGroup()).add("VPCZoneIdentifier", (Object)this.vpcZoneIdentifier()).add("TerminationPolicies", this.terminationPolicies()).add("NewInstancesProtectedFromScaleIn", (Object)this.newInstancesProtectedFromScaleIn()).add("ServiceLinkedRoleARN", (Object)this.serviceLinkedRoleARN()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoScalingGroupName": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroupName()));
            }
            case "LaunchConfigurationName": {
                return Optional.ofNullable(clazz.cast(this.launchConfigurationName()));
            }
            case "LaunchTemplate": {
                return Optional.ofNullable(clazz.cast(this.launchTemplate()));
            }
            case "MinSize": {
                return Optional.ofNullable(clazz.cast(this.minSize()));
            }
            case "MaxSize": {
                return Optional.ofNullable(clazz.cast(this.maxSize()));
            }
            case "DesiredCapacity": {
                return Optional.ofNullable(clazz.cast(this.desiredCapacity()));
            }
            case "DefaultCooldown": {
                return Optional.ofNullable(clazz.cast(this.defaultCooldown()));
            }
            case "AvailabilityZones": {
                return Optional.ofNullable(clazz.cast(this.availabilityZones()));
            }
            case "HealthCheckType": {
                return Optional.ofNullable(clazz.cast(this.healthCheckType()));
            }
            case "HealthCheckGracePeriod": {
                return Optional.ofNullable(clazz.cast(this.healthCheckGracePeriod()));
            }
            case "PlacementGroup": {
                return Optional.ofNullable(clazz.cast(this.placementGroup()));
            }
            case "VPCZoneIdentifier": {
                return Optional.ofNullable(clazz.cast(this.vpcZoneIdentifier()));
            }
            case "TerminationPolicies": {
                return Optional.ofNullable(clazz.cast(this.terminationPolicies()));
            }
            case "NewInstancesProtectedFromScaleIn": {
                return Optional.ofNullable(clazz.cast(this.newInstancesProtectedFromScaleIn()));
            }
            case "ServiceLinkedRoleARN": {
                return Optional.ofNullable(clazz.cast(this.serviceLinkedRoleARN()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAutoScalingGroupRequest, T> g) {
        return obj -> g.apply((UpdateAutoScalingGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AutoScalingRequest.BuilderImpl
    implements Builder {
        private String autoScalingGroupName;
        private String launchConfigurationName;
        private LaunchTemplateSpecification launchTemplate;
        private Integer minSize;
        private Integer maxSize;
        private Integer desiredCapacity;
        private Integer defaultCooldown;
        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();
        private String healthCheckType;
        private Integer healthCheckGracePeriod;
        private String placementGroup;
        private String vpcZoneIdentifier;
        private List<String> terminationPolicies = DefaultSdkAutoConstructList.getInstance();
        private Boolean newInstancesProtectedFromScaleIn;
        private String serviceLinkedRoleARN;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAutoScalingGroupRequest model) {
            super(model);
            this.autoScalingGroupName(model.autoScalingGroupName);
            this.launchConfigurationName(model.launchConfigurationName);
            this.launchTemplate(model.launchTemplate);
            this.minSize(model.minSize);
            this.maxSize(model.maxSize);
            this.desiredCapacity(model.desiredCapacity);
            this.defaultCooldown(model.defaultCooldown);
            this.availabilityZones(model.availabilityZones);
            this.healthCheckType(model.healthCheckType);
            this.healthCheckGracePeriod(model.healthCheckGracePeriod);
            this.placementGroup(model.placementGroup);
            this.vpcZoneIdentifier(model.vpcZoneIdentifier);
            this.terminationPolicies(model.terminationPolicies);
            this.newInstancesProtectedFromScaleIn(model.newInstancesProtectedFromScaleIn);
            this.serviceLinkedRoleARN(model.serviceLinkedRoleARN);
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final String getLaunchConfigurationName() {
            return this.launchConfigurationName;
        }

        @Override
        public final Builder launchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
            return this;
        }

        public final void setLaunchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
        }

        public final LaunchTemplateSpecification.Builder getLaunchTemplate() {
            return this.launchTemplate != null ? this.launchTemplate.toBuilder() : null;
        }

        @Override
        public final Builder launchTemplate(LaunchTemplateSpecification launchTemplate) {
            this.launchTemplate = launchTemplate;
            return this;
        }

        public final void setLaunchTemplate(LaunchTemplateSpecification.BuilderImpl launchTemplate) {
            this.launchTemplate = launchTemplate != null ? launchTemplate.build() : null;
        }

        public final Integer getMinSize() {
            return this.minSize;
        }

        @Override
        public final Builder minSize(Integer minSize) {
            this.minSize = minSize;
            return this;
        }

        public final void setMinSize(Integer minSize) {
            this.minSize = minSize;
        }

        public final Integer getMaxSize() {
            return this.maxSize;
        }

        @Override
        public final Builder maxSize(Integer maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public final void setMaxSize(Integer maxSize) {
            this.maxSize = maxSize;
        }

        public final Integer getDesiredCapacity() {
            return this.desiredCapacity;
        }

        @Override
        public final Builder desiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
            return this;
        }

        public final void setDesiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
        }

        public final Integer getDefaultCooldown() {
            return this.defaultCooldown;
        }

        @Override
        public final Builder defaultCooldown(Integer defaultCooldown) {
            this.defaultCooldown = defaultCooldown;
            return this;
        }

        public final void setDefaultCooldown(Integer defaultCooldown) {
            this.defaultCooldown = defaultCooldown;
        }

        public final Collection<String> getAvailabilityZones() {
            return this.availabilityZones;
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
        }

        public final String getHealthCheckType() {
            return this.healthCheckType;
        }

        @Override
        public final Builder healthCheckType(String healthCheckType) {
            this.healthCheckType = healthCheckType;
            return this;
        }

        public final void setHealthCheckType(String healthCheckType) {
            this.healthCheckType = healthCheckType;
        }

        public final Integer getHealthCheckGracePeriod() {
            return this.healthCheckGracePeriod;
        }

        @Override
        public final Builder healthCheckGracePeriod(Integer healthCheckGracePeriod) {
            this.healthCheckGracePeriod = healthCheckGracePeriod;
            return this;
        }

        public final void setHealthCheckGracePeriod(Integer healthCheckGracePeriod) {
            this.healthCheckGracePeriod = healthCheckGracePeriod;
        }

        public final String getPlacementGroup() {
            return this.placementGroup;
        }

        @Override
        public final Builder placementGroup(String placementGroup) {
            this.placementGroup = placementGroup;
            return this;
        }

        public final void setPlacementGroup(String placementGroup) {
            this.placementGroup = placementGroup;
        }

        public final String getVPCZoneIdentifier() {
            return this.vpcZoneIdentifier;
        }

        @Override
        public final Builder vpcZoneIdentifier(String vpcZoneIdentifier) {
            this.vpcZoneIdentifier = vpcZoneIdentifier;
            return this;
        }

        public final void setVPCZoneIdentifier(String vpcZoneIdentifier) {
            this.vpcZoneIdentifier = vpcZoneIdentifier;
        }

        public final Collection<String> getTerminationPolicies() {
            return this.terminationPolicies;
        }

        @Override
        public final Builder terminationPolicies(Collection<String> terminationPolicies) {
            this.terminationPolicies = TerminationPoliciesCopier.copy(terminationPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder terminationPolicies(String ... terminationPolicies) {
            this.terminationPolicies(Arrays.asList(terminationPolicies));
            return this;
        }

        public final void setTerminationPolicies(Collection<String> terminationPolicies) {
            this.terminationPolicies = TerminationPoliciesCopier.copy(terminationPolicies);
        }

        public final Boolean getNewInstancesProtectedFromScaleIn() {
            return this.newInstancesProtectedFromScaleIn;
        }

        @Override
        public final Builder newInstancesProtectedFromScaleIn(Boolean newInstancesProtectedFromScaleIn) {
            this.newInstancesProtectedFromScaleIn = newInstancesProtectedFromScaleIn;
            return this;
        }

        public final void setNewInstancesProtectedFromScaleIn(Boolean newInstancesProtectedFromScaleIn) {
            this.newInstancesProtectedFromScaleIn = newInstancesProtectedFromScaleIn;
        }

        public final String getServiceLinkedRoleARN() {
            return this.serviceLinkedRoleARN;
        }

        @Override
        public final Builder serviceLinkedRoleARN(String serviceLinkedRoleARN) {
            this.serviceLinkedRoleARN = serviceLinkedRoleARN;
            return this;
        }

        public final void setServiceLinkedRoleARN(String serviceLinkedRoleARN) {
            this.serviceLinkedRoleARN = serviceLinkedRoleARN;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAutoScalingGroupRequest build() {
            return new UpdateAutoScalingGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AutoScalingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAutoScalingGroupRequest> {
        public Builder autoScalingGroupName(String var1);

        public Builder launchConfigurationName(String var1);

        public Builder launchTemplate(LaunchTemplateSpecification var1);

        default public Builder launchTemplate(Consumer<LaunchTemplateSpecification.Builder> launchTemplate) {
            return this.launchTemplate((LaunchTemplateSpecification)((LaunchTemplateSpecification.Builder)LaunchTemplateSpecification.builder().applyMutation(launchTemplate)).build());
        }

        public Builder minSize(Integer var1);

        public Builder maxSize(Integer var1);

        public Builder desiredCapacity(Integer var1);

        public Builder defaultCooldown(Integer var1);

        public Builder availabilityZones(Collection<String> var1);

        public Builder availabilityZones(String ... var1);

        public Builder healthCheckType(String var1);

        public Builder healthCheckGracePeriod(Integer var1);

        public Builder placementGroup(String var1);

        public Builder vpcZoneIdentifier(String var1);

        public Builder terminationPolicies(Collection<String> var1);

        public Builder terminationPolicies(String ... var1);

        public Builder newInstancesProtectedFromScaleIn(Boolean var1);

        public Builder serviceLinkedRoleARN(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

