/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribePoliciesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribePoliciesRequest.Builder, DescribePoliciesRequest> {
    private final String autoScalingGroupName;

    private final List<String> policyNames;

    private final List<String> policyTypes;

    private final String nextToken;

    private final Integer maxRecords;

    private DescribePoliciesRequest(BuilderImpl builder) {
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.policyNames = builder.policyNames;
        this.policyTypes = builder.policyTypes;
        this.nextToken = builder.nextToken;
        this.maxRecords = builder.maxRecords;
    }

    /**
     * <p>
     * The name of the group.
     * </p>
     * 
     * @return The name of the group.
     */
    public String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * <p>
     * One or more policy names or policy ARNs to be described. If you omit this parameter, all policy names are
     * described. If an group name is provided, the results are limited to that group. This list is limited to 50 items.
     * If you specify an unknown policy name, it is ignored with no error.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more policy names or policy ARNs to be described. If you omit this parameter, all policy names are
     *         described. If an group name is provided, the results are limited to that group. This list is limited to
     *         50 items. If you specify an unknown policy name, it is ignored with no error.
     */
    public List<String> policyNames() {
        return policyNames;
    }

    /**
     * <p>
     * One or more policy types. Valid values are <code>SimpleScaling</code> and <code>StepScaling</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more policy types. Valid values are <code>SimpleScaling</code> and <code>StepScaling</code>.
     */
    public List<String> policyTypes() {
        return policyTypes;
    }

    /**
     * <p>
     * The token for the next set of items to return. (You received this token from a previous call.)
     * </p>
     * 
     * @return The token for the next set of items to return. (You received this token from a previous call.)
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of items to be returned with each call. The default value is 50 and the maximum value is 100.
     * </p>
     * 
     * @return The maximum number of items to be returned with each call. The default value is 50 and the maximum value
     *         is 100.
     */
    public Integer maxRecords() {
        return maxRecords;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((autoScalingGroupName() == null) ? 0 : autoScalingGroupName().hashCode());
        hashCode = 31 * hashCode + ((policyNames() == null) ? 0 : policyNames().hashCode());
        hashCode = 31 * hashCode + ((policyTypes() == null) ? 0 : policyTypes().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        hashCode = 31 * hashCode + ((maxRecords() == null) ? 0 : maxRecords().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePoliciesRequest)) {
            return false;
        }
        DescribePoliciesRequest other = (DescribePoliciesRequest) obj;
        if (other.autoScalingGroupName() == null ^ this.autoScalingGroupName() == null) {
            return false;
        }
        if (other.autoScalingGroupName() != null && !other.autoScalingGroupName().equals(this.autoScalingGroupName())) {
            return false;
        }
        if (other.policyNames() == null ^ this.policyNames() == null) {
            return false;
        }
        if (other.policyNames() != null && !other.policyNames().equals(this.policyNames())) {
            return false;
        }
        if (other.policyTypes() == null ^ this.policyTypes() == null) {
            return false;
        }
        if (other.policyTypes() != null && !other.policyTypes().equals(this.policyTypes())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.maxRecords() == null ^ this.maxRecords() == null) {
            return false;
        }
        if (other.maxRecords() != null && !other.maxRecords().equals(this.maxRecords())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (autoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: ").append(autoScalingGroupName()).append(",");
        }
        if (policyNames() != null) {
            sb.append("PolicyNames: ").append(policyNames()).append(",");
        }
        if (policyTypes() != null) {
            sb.append("PolicyTypes: ").append(policyTypes()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (maxRecords() != null) {
            sb.append("MaxRecords: ").append(maxRecords()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribePoliciesRequest> {
        /**
         * <p>
         * The name of the group.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * One or more policy names or policy ARNs to be described. If you omit this parameter, all policy names are
         * described. If an group name is provided, the results are limited to that group. This list is limited to 50
         * items. If you specify an unknown policy name, it is ignored with no error.
         * </p>
         * 
         * @param policyNames
         *        One or more policy names or policy ARNs to be described. If you omit this parameter, all policy names
         *        are described. If an group name is provided, the results are limited to that group. This list is
         *        limited to 50 items. If you specify an unknown policy name, it is ignored with no error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyNames(Collection<String> policyNames);

        /**
         * <p>
         * One or more policy names or policy ARNs to be described. If you omit this parameter, all policy names are
         * described. If an group name is provided, the results are limited to that group. This list is limited to 50
         * items. If you specify an unknown policy name, it is ignored with no error.
         * </p>
         * 
         * @param policyNames
         *        One or more policy names or policy ARNs to be described. If you omit this parameter, all policy names
         *        are described. If an group name is provided, the results are limited to that group. This list is
         *        limited to 50 items. If you specify an unknown policy name, it is ignored with no error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyNames(String... policyNames);

        /**
         * <p>
         * One or more policy types. Valid values are <code>SimpleScaling</code> and <code>StepScaling</code>.
         * </p>
         * 
         * @param policyTypes
         *        One or more policy types. Valid values are <code>SimpleScaling</code> and <code>StepScaling</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyTypes(Collection<String> policyTypes);

        /**
         * <p>
         * One or more policy types. Valid values are <code>SimpleScaling</code> and <code>StepScaling</code>.
         * </p>
         * 
         * @param policyTypes
         *        One or more policy types. Valid values are <code>SimpleScaling</code> and <code>StepScaling</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyTypes(String... policyTypes);

        /**
         * <p>
         * The token for the next set of items to return. (You received this token from a previous call.)
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. (You received this token from a previous call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of items to be returned with each call. The default value is 50 and the maximum value is
         * 100.
         * </p>
         * 
         * @param maxRecords
         *        The maximum number of items to be returned with each call. The default value is 50 and the maximum
         *        value is 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecords(Integer maxRecords);
    }

    private static final class BuilderImpl implements Builder {
        private String autoScalingGroupName;

        private List<String> policyNames;

        private List<String> policyTypes;

        private String nextToken;

        private Integer maxRecords;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePoliciesRequest model) {
            setAutoScalingGroupName(model.autoScalingGroupName);
            setPolicyNames(model.policyNames);
            setPolicyTypes(model.policyTypes);
            setNextToken(model.nextToken);
            setMaxRecords(model.maxRecords);
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final Collection<String> getPolicyNames() {
            return policyNames;
        }

        @Override
        public final Builder policyNames(Collection<String> policyNames) {
            this.policyNames = PolicyNamesCopier.copy(policyNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyNames(String... policyNames) {
            policyNames(Arrays.asList(policyNames));
            return this;
        }

        public final void setPolicyNames(Collection<String> policyNames) {
            this.policyNames = PolicyNamesCopier.copy(policyNames);
        }

        @SafeVarargs
        public final void setPolicyNames(String... policyNames) {
            policyNames(Arrays.asList(policyNames));
        }

        public final Collection<String> getPolicyTypes() {
            return policyTypes;
        }

        @Override
        public final Builder policyTypes(Collection<String> policyTypes) {
            this.policyTypes = PolicyTypesCopier.copy(policyTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyTypes(String... policyTypes) {
            policyTypes(Arrays.asList(policyTypes));
            return this;
        }

        public final void setPolicyTypes(Collection<String> policyTypes) {
            this.policyTypes = PolicyTypesCopier.copy(policyTypes);
        }

        @SafeVarargs
        public final void setPolicyTypes(String... policyTypes) {
            policyTypes(Arrays.asList(policyTypes));
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxRecords() {
            return maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        @Override
        public DescribePoliciesRequest build() {
            return new DescribePoliciesRequest(this);
        }
    }
}
