/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeScalingActivitiesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeScalingActivitiesResponse.Builder, DescribeScalingActivitiesResponse> {
    private final List<Activity> activities;

    private final String nextToken;

    private DescribeScalingActivitiesResponse(BuilderImpl builder) {
        this.activities = builder.activities;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The scaling activities. Activities are sorted by start time. Activities still in progress are described first.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The scaling activities. Activities are sorted by start time. Activities still in progress are described
     *         first.
     */
    public List<Activity> activities() {
        return activities;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((activities() == null) ? 0 : activities().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScalingActivitiesResponse)) {
            return false;
        }
        DescribeScalingActivitiesResponse other = (DescribeScalingActivitiesResponse) obj;
        if (other.activities() == null ^ this.activities() == null) {
            return false;
        }
        if (other.activities() != null && !other.activities().equals(this.activities())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (activities() != null) {
            sb.append("Activities: ").append(activities()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeScalingActivitiesResponse> {
        /**
         * <p>
         * The scaling activities. Activities are sorted by start time. Activities still in progress are described
         * first.
         * </p>
         * 
         * @param activities
         *        The scaling activities. Activities are sorted by start time. Activities still in progress are
         *        described first.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activities(Collection<Activity> activities);

        /**
         * <p>
         * The scaling activities. Activities are sorted by start time. Activities still in progress are described
         * first.
         * </p>
         * 
         * @param activities
         *        The scaling activities. Activities are sorted by start time. Activities still in progress are
         *        described first.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activities(Activity... activities);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<Activity> activities;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScalingActivitiesResponse model) {
            setActivities(model.activities);
            setNextToken(model.nextToken);
        }

        public final Collection<Activity> getActivities() {
            return activities;
        }

        @Override
        public final Builder activities(Collection<Activity> activities) {
            this.activities = ActivitiesCopier.copy(activities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activities(Activity... activities) {
            activities(Arrays.asList(activities));
            return this;
        }

        public final void setActivities(Collection<Activity> activities) {
            this.activities = ActivitiesCopier.copy(activities);
        }

        @SafeVarargs
        public final void setActivities(Activity... activities) {
            activities(Arrays.asList(activities));
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeScalingActivitiesResponse build() {
            return new DescribeScalingActivitiesResponse(this);
        }
    }
}
