/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeTerminationPolicyTypesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeTerminationPolicyTypesResponse.Builder, DescribeTerminationPolicyTypesResponse> {
    private final List<String> terminationPolicyTypes;

    private DescribeTerminationPolicyTypesResponse(BuilderImpl builder) {
        this.terminationPolicyTypes = builder.terminationPolicyTypes;
    }

    /**
     * <p>
     * The termination policies supported by Auto Scaling (<code>OldestInstance</code>,
     * <code>OldestLaunchConfiguration</code>, <code>NewestInstance</code>, <code>ClosestToNextInstanceHour</code>, and
     * <code>Default</code>).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The termination policies supported by Auto Scaling (<code>OldestInstance</code>,
     *         <code>OldestLaunchConfiguration</code>, <code>NewestInstance</code>,
     *         <code>ClosestToNextInstanceHour</code>, and <code>Default</code>).
     */
    public List<String> terminationPolicyTypes() {
        return terminationPolicyTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((terminationPolicyTypes() == null) ? 0 : terminationPolicyTypes().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTerminationPolicyTypesResponse)) {
            return false;
        }
        DescribeTerminationPolicyTypesResponse other = (DescribeTerminationPolicyTypesResponse) obj;
        if (other.terminationPolicyTypes() == null ^ this.terminationPolicyTypes() == null) {
            return false;
        }
        if (other.terminationPolicyTypes() != null && !other.terminationPolicyTypes().equals(this.terminationPolicyTypes())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (terminationPolicyTypes() != null) {
            sb.append("TerminationPolicyTypes: ").append(terminationPolicyTypes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeTerminationPolicyTypesResponse> {
        /**
         * <p>
         * The termination policies supported by Auto Scaling (<code>OldestInstance</code>,
         * <code>OldestLaunchConfiguration</code>, <code>NewestInstance</code>, <code>ClosestToNextInstanceHour</code>,
         * and <code>Default</code>).
         * </p>
         * 
         * @param terminationPolicyTypes
         *        The termination policies supported by Auto Scaling (<code>OldestInstance</code>,
         *        <code>OldestLaunchConfiguration</code>, <code>NewestInstance</code>,
         *        <code>ClosestToNextInstanceHour</code>, and <code>Default</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminationPolicyTypes(Collection<String> terminationPolicyTypes);

        /**
         * <p>
         * The termination policies supported by Auto Scaling (<code>OldestInstance</code>,
         * <code>OldestLaunchConfiguration</code>, <code>NewestInstance</code>, <code>ClosestToNextInstanceHour</code>,
         * and <code>Default</code>).
         * </p>
         * 
         * @param terminationPolicyTypes
         *        The termination policies supported by Auto Scaling (<code>OldestInstance</code>,
         *        <code>OldestLaunchConfiguration</code>, <code>NewestInstance</code>,
         *        <code>ClosestToNextInstanceHour</code>, and <code>Default</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminationPolicyTypes(String... terminationPolicyTypes);
    }

    private static final class BuilderImpl implements Builder {
        private List<String> terminationPolicyTypes;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTerminationPolicyTypesResponse model) {
            setTerminationPolicyTypes(model.terminationPolicyTypes);
        }

        public final Collection<String> getTerminationPolicyTypes() {
            return terminationPolicyTypes;
        }

        @Override
        public final Builder terminationPolicyTypes(Collection<String> terminationPolicyTypes) {
            this.terminationPolicyTypes = TerminationPoliciesCopier.copy(terminationPolicyTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder terminationPolicyTypes(String... terminationPolicyTypes) {
            terminationPolicyTypes(Arrays.asList(terminationPolicyTypes));
            return this;
        }

        public final void setTerminationPolicyTypes(Collection<String> terminationPolicyTypes) {
            this.terminationPolicyTypes = TerminationPoliciesCopier.copy(terminationPolicyTypes);
        }

        @SafeVarargs
        public final void setTerminationPolicyTypes(String... terminationPolicyTypes) {
            terminationPolicyTypes(Arrays.asList(terminationPolicyTypes));
        }

        @Override
        public DescribeTerminationPolicyTypesResponse build() {
            return new DescribeTerminationPolicyTypesResponse(this);
        }
    }
}
