/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class EnterStandbyResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<EnterStandbyResponse.Builder, EnterStandbyResponse> {
    private final List<Activity> activities;

    private EnterStandbyResponse(BuilderImpl builder) {
        this.activities = builder.activities;
    }

    /**
     * <p>
     * The activities related to moving instances into <code>Standby</code> mode.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The activities related to moving instances into <code>Standby</code> mode.
     */
    public List<Activity> activities() {
        return activities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((activities() == null) ? 0 : activities().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnterStandbyResponse)) {
            return false;
        }
        EnterStandbyResponse other = (EnterStandbyResponse) obj;
        if (other.activities() == null ^ this.activities() == null) {
            return false;
        }
        if (other.activities() != null && !other.activities().equals(this.activities())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (activities() != null) {
            sb.append("Activities: ").append(activities()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, EnterStandbyResponse> {
        /**
         * <p>
         * The activities related to moving instances into <code>Standby</code> mode.
         * </p>
         * 
         * @param activities
         *        The activities related to moving instances into <code>Standby</code> mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activities(Collection<Activity> activities);

        /**
         * <p>
         * The activities related to moving instances into <code>Standby</code> mode.
         * </p>
         * 
         * @param activities
         *        The activities related to moving instances into <code>Standby</code> mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activities(Activity... activities);
    }

    private static final class BuilderImpl implements Builder {
        private List<Activity> activities;

        private BuilderImpl() {
        }

        private BuilderImpl(EnterStandbyResponse model) {
            setActivities(model.activities);
        }

        public final Collection<Activity> getActivities() {
            return activities;
        }

        @Override
        public final Builder activities(Collection<Activity> activities) {
            this.activities = ActivitiesCopier.copy(activities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activities(Activity... activities) {
            activities(Arrays.asList(activities));
            return this;
        }

        public final void setActivities(Collection<Activity> activities) {
            this.activities = ActivitiesCopier.copy(activities);
        }

        @SafeVarargs
        public final void setActivities(Activity... activities) {
            activities(Arrays.asList(activities));
        }

        @Override
        public EnterStandbyResponse build() {
            return new EnterStandbyResponse(this);
        }
    }
}
