/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class PutScheduledUpdateGroupActionRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<PutScheduledUpdateGroupActionRequest.Builder, PutScheduledUpdateGroupActionRequest> {
    private final String autoScalingGroupName;

    private final String scheduledActionName;

    private final Instant time;

    private final Instant startTime;

    private final Instant endTime;

    private final String recurrence;

    private final Integer minSize;

    private final Integer maxSize;

    private final Integer desiredCapacity;

    private PutScheduledUpdateGroupActionRequest(BuilderImpl builder) {
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.scheduledActionName = builder.scheduledActionName;
        this.time = builder.time;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.recurrence = builder.recurrence;
        this.minSize = builder.minSize;
        this.maxSize = builder.maxSize;
        this.desiredCapacity = builder.desiredCapacity;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of the Auto Scaling group.
     * </p>
     * 
     * @return The name or Amazon Resource Name (ARN) of the Auto Scaling group.
     */
    public String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * <p>
     * The name of this scaling action.
     * </p>
     * 
     * @return The name of this scaling action.
     */
    public String scheduledActionName() {
        return scheduledActionName;
    }

    /**
     * <p>
     * This parameter is deprecated.
     * </p>
     * 
     * @return This parameter is deprecated.
     */
    public Instant time() {
        return time;
    }

    /**
     * <p>
     * The time for this action to start, in "YYYY-MM-DDThh:mm:ssZ" format in UTC/GMT only (for example,
     * <code>2014-06-01T00:00:00Z</code>).
     * </p>
     * <p>
     * If you specify <code>Recurrence</code> and <code>StartTime</code>, Auto Scaling performs the action at this time,
     * and then performs the action based on the specified recurrence.
     * </p>
     * <p>
     * If you try to schedule your action in the past, Auto Scaling returns an error message.
     * </p>
     * 
     * @return The time for this action to start, in "YYYY-MM-DDThh:mm:ssZ" format in UTC/GMT only (for example,
     *         <code>2014-06-01T00:00:00Z</code>).</p>
     *         <p>
     *         If you specify <code>Recurrence</code> and <code>StartTime</code>, Auto Scaling performs the action at
     *         this time, and then performs the action based on the specified recurrence.
     *         </p>
     *         <p>
     *         If you try to schedule your action in the past, Auto Scaling returns an error message.
     */
    public Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The time for the recurring schedule to end. Auto Scaling does not perform the action after this time.
     * </p>
     * 
     * @return The time for the recurring schedule to end. Auto Scaling does not perform the action after this time.
     */
    public Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The recurring schedule for this action, in Unix cron syntax format. For more information, see <a
     * href="http://en.wikipedia.org/wiki/Cron">Cron</a> in Wikipedia.
     * </p>
     * 
     * @return The recurring schedule for this action, in Unix cron syntax format. For more information, see <a
     *         href="http://en.wikipedia.org/wiki/Cron">Cron</a> in Wikipedia.
     */
    public String recurrence() {
        return recurrence;
    }

    /**
     * <p>
     * The minimum size for the Auto Scaling group.
     * </p>
     * 
     * @return The minimum size for the Auto Scaling group.
     */
    public Integer minSize() {
        return minSize;
    }

    /**
     * <p>
     * The maximum size for the Auto Scaling group.
     * </p>
     * 
     * @return The maximum size for the Auto Scaling group.
     */
    public Integer maxSize() {
        return maxSize;
    }

    /**
     * <p>
     * The number of EC2 instances that should be running in the group.
     * </p>
     * 
     * @return The number of EC2 instances that should be running in the group.
     */
    public Integer desiredCapacity() {
        return desiredCapacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((autoScalingGroupName() == null) ? 0 : autoScalingGroupName().hashCode());
        hashCode = 31 * hashCode + ((scheduledActionName() == null) ? 0 : scheduledActionName().hashCode());
        hashCode = 31 * hashCode + ((time() == null) ? 0 : time().hashCode());
        hashCode = 31 * hashCode + ((startTime() == null) ? 0 : startTime().hashCode());
        hashCode = 31 * hashCode + ((endTime() == null) ? 0 : endTime().hashCode());
        hashCode = 31 * hashCode + ((recurrence() == null) ? 0 : recurrence().hashCode());
        hashCode = 31 * hashCode + ((minSize() == null) ? 0 : minSize().hashCode());
        hashCode = 31 * hashCode + ((maxSize() == null) ? 0 : maxSize().hashCode());
        hashCode = 31 * hashCode + ((desiredCapacity() == null) ? 0 : desiredCapacity().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutScheduledUpdateGroupActionRequest)) {
            return false;
        }
        PutScheduledUpdateGroupActionRequest other = (PutScheduledUpdateGroupActionRequest) obj;
        if (other.autoScalingGroupName() == null ^ this.autoScalingGroupName() == null) {
            return false;
        }
        if (other.autoScalingGroupName() != null && !other.autoScalingGroupName().equals(this.autoScalingGroupName())) {
            return false;
        }
        if (other.scheduledActionName() == null ^ this.scheduledActionName() == null) {
            return false;
        }
        if (other.scheduledActionName() != null && !other.scheduledActionName().equals(this.scheduledActionName())) {
            return false;
        }
        if (other.time() == null ^ this.time() == null) {
            return false;
        }
        if (other.time() != null && !other.time().equals(this.time())) {
            return false;
        }
        if (other.startTime() == null ^ this.startTime() == null) {
            return false;
        }
        if (other.startTime() != null && !other.startTime().equals(this.startTime())) {
            return false;
        }
        if (other.endTime() == null ^ this.endTime() == null) {
            return false;
        }
        if (other.endTime() != null && !other.endTime().equals(this.endTime())) {
            return false;
        }
        if (other.recurrence() == null ^ this.recurrence() == null) {
            return false;
        }
        if (other.recurrence() != null && !other.recurrence().equals(this.recurrence())) {
            return false;
        }
        if (other.minSize() == null ^ this.minSize() == null) {
            return false;
        }
        if (other.minSize() != null && !other.minSize().equals(this.minSize())) {
            return false;
        }
        if (other.maxSize() == null ^ this.maxSize() == null) {
            return false;
        }
        if (other.maxSize() != null && !other.maxSize().equals(this.maxSize())) {
            return false;
        }
        if (other.desiredCapacity() == null ^ this.desiredCapacity() == null) {
            return false;
        }
        if (other.desiredCapacity() != null && !other.desiredCapacity().equals(this.desiredCapacity())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (autoScalingGroupName() != null) {
            sb.append("AutoScalingGroupName: ").append(autoScalingGroupName()).append(",");
        }
        if (scheduledActionName() != null) {
            sb.append("ScheduledActionName: ").append(scheduledActionName()).append(",");
        }
        if (time() != null) {
            sb.append("Time: ").append(time()).append(",");
        }
        if (startTime() != null) {
            sb.append("StartTime: ").append(startTime()).append(",");
        }
        if (endTime() != null) {
            sb.append("EndTime: ").append(endTime()).append(",");
        }
        if (recurrence() != null) {
            sb.append("Recurrence: ").append(recurrence()).append(",");
        }
        if (minSize() != null) {
            sb.append("MinSize: ").append(minSize()).append(",");
        }
        if (maxSize() != null) {
            sb.append("MaxSize: ").append(maxSize()).append(",");
        }
        if (desiredCapacity() != null) {
            sb.append("DesiredCapacity: ").append(desiredCapacity()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, PutScheduledUpdateGroupActionRequest> {
        /**
         * <p>
         * The name or Amazon Resource Name (ARN) of the Auto Scaling group.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name or Amazon Resource Name (ARN) of the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * The name of this scaling action.
         * </p>
         * 
         * @param scheduledActionName
         *        The name of this scaling action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledActionName(String scheduledActionName);

        /**
         * <p>
         * This parameter is deprecated.
         * </p>
         * 
         * @param time
         *        This parameter is deprecated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder time(Instant time);

        /**
         * <p>
         * The time for this action to start, in "YYYY-MM-DDThh:mm:ssZ" format in UTC/GMT only (for example,
         * <code>2014-06-01T00:00:00Z</code>).
         * </p>
         * <p>
         * If you specify <code>Recurrence</code> and <code>StartTime</code>, Auto Scaling performs the action at this
         * time, and then performs the action based on the specified recurrence.
         * </p>
         * <p>
         * If you try to schedule your action in the past, Auto Scaling returns an error message.
         * </p>
         * 
         * @param startTime
         *        The time for this action to start, in "YYYY-MM-DDThh:mm:ssZ" format in UTC/GMT only (for example,
         *        <code>2014-06-01T00:00:00Z</code>).</p>
         *        <p>
         *        If you specify <code>Recurrence</code> and <code>StartTime</code>, Auto Scaling performs the action at
         *        this time, and then performs the action based on the specified recurrence.
         *        </p>
         *        <p>
         *        If you try to schedule your action in the past, Auto Scaling returns an error message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The time for the recurring schedule to end. Auto Scaling does not perform the action after this time.
         * </p>
         * 
         * @param endTime
         *        The time for the recurring schedule to end. Auto Scaling does not perform the action after this time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The recurring schedule for this action, in Unix cron syntax format. For more information, see <a
         * href="http://en.wikipedia.org/wiki/Cron">Cron</a> in Wikipedia.
         * </p>
         * 
         * @param recurrence
         *        The recurring schedule for this action, in Unix cron syntax format. For more information, see <a
         *        href="http://en.wikipedia.org/wiki/Cron">Cron</a> in Wikipedia.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recurrence(String recurrence);

        /**
         * <p>
         * The minimum size for the Auto Scaling group.
         * </p>
         * 
         * @param minSize
         *        The minimum size for the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minSize(Integer minSize);

        /**
         * <p>
         * The maximum size for the Auto Scaling group.
         * </p>
         * 
         * @param maxSize
         *        The maximum size for the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxSize(Integer maxSize);

        /**
         * <p>
         * The number of EC2 instances that should be running in the group.
         * </p>
         * 
         * @param desiredCapacity
         *        The number of EC2 instances that should be running in the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredCapacity(Integer desiredCapacity);
    }

    private static final class BuilderImpl implements Builder {
        private String autoScalingGroupName;

        private String scheduledActionName;

        private Instant time;

        private Instant startTime;

        private Instant endTime;

        private String recurrence;

        private Integer minSize;

        private Integer maxSize;

        private Integer desiredCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(PutScheduledUpdateGroupActionRequest model) {
            setAutoScalingGroupName(model.autoScalingGroupName);
            setScheduledActionName(model.scheduledActionName);
            setTime(model.time);
            setStartTime(model.startTime);
            setEndTime(model.endTime);
            setRecurrence(model.recurrence);
            setMinSize(model.minSize);
            setMaxSize(model.maxSize);
            setDesiredCapacity(model.desiredCapacity);
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final String getScheduledActionName() {
            return scheduledActionName;
        }

        @Override
        public final Builder scheduledActionName(String scheduledActionName) {
            this.scheduledActionName = scheduledActionName;
            return this;
        }

        public final void setScheduledActionName(String scheduledActionName) {
            this.scheduledActionName = scheduledActionName;
        }

        public final Instant getTime() {
            return time;
        }

        @Override
        public final Builder time(Instant time) {
            this.time = time;
            return this;
        }

        public final void setTime(Instant time) {
            this.time = time;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final String getRecurrence() {
            return recurrence;
        }

        @Override
        public final Builder recurrence(String recurrence) {
            this.recurrence = recurrence;
            return this;
        }

        public final void setRecurrence(String recurrence) {
            this.recurrence = recurrence;
        }

        public final Integer getMinSize() {
            return minSize;
        }

        @Override
        public final Builder minSize(Integer minSize) {
            this.minSize = minSize;
            return this;
        }

        public final void setMinSize(Integer minSize) {
            this.minSize = minSize;
        }

        public final Integer getMaxSize() {
            return maxSize;
        }

        @Override
        public final Builder maxSize(Integer maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public final void setMaxSize(Integer maxSize) {
            this.maxSize = maxSize;
        }

        public final Integer getDesiredCapacity() {
            return desiredCapacity;
        }

        @Override
        public final Builder desiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
            return this;
        }

        public final void setDesiredCapacity(Integer desiredCapacity) {
            this.desiredCapacity = desiredCapacity;
        }

        @Override
        public PutScheduledUpdateGroupActionRequest build() {
            return new PutScheduledUpdateGroupActionRequest(this);
        }
    }
}
