/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a tag for an Auto Scaling group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class TagDescription implements ToCopyableBuilder<TagDescription.Builder, TagDescription> {
    private final String resourceId;

    private final String resourceType;

    private final String key;

    private final String value;

    private final Boolean propagateAtLaunch;

    private TagDescription(BuilderImpl builder) {
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
        this.key = builder.key;
        this.value = builder.value;
        this.propagateAtLaunch = builder.propagateAtLaunch;
    }

    /**
     * <p>
     * The name of the group.
     * </p>
     * 
     * @return The name of the group.
     */
    public String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The type of resource. The only supported value is <code>auto-scaling-group</code>.
     * </p>
     * 
     * @return The type of resource. The only supported value is <code>auto-scaling-group</code>.
     */
    public String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The tag key.
     * </p>
     * 
     * @return The tag key.
     */
    public String key() {
        return key;
    }

    /**
     * <p>
     * The tag value.
     * </p>
     * 
     * @return The tag value.
     */
    public String value() {
        return value;
    }

    /**
     * <p>
     * Determines whether the tag is added to new instances as they are launched in the group.
     * </p>
     * 
     * @return Determines whether the tag is added to new instances as they are launched in the group.
     */
    public Boolean propagateAtLaunch() {
        return propagateAtLaunch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((resourceId() == null) ? 0 : resourceId().hashCode());
        hashCode = 31 * hashCode + ((resourceType() == null) ? 0 : resourceType().hashCode());
        hashCode = 31 * hashCode + ((key() == null) ? 0 : key().hashCode());
        hashCode = 31 * hashCode + ((value() == null) ? 0 : value().hashCode());
        hashCode = 31 * hashCode + ((propagateAtLaunch() == null) ? 0 : propagateAtLaunch().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TagDescription)) {
            return false;
        }
        TagDescription other = (TagDescription) obj;
        if (other.resourceId() == null ^ this.resourceId() == null) {
            return false;
        }
        if (other.resourceId() != null && !other.resourceId().equals(this.resourceId())) {
            return false;
        }
        if (other.resourceType() == null ^ this.resourceType() == null) {
            return false;
        }
        if (other.resourceType() != null && !other.resourceType().equals(this.resourceType())) {
            return false;
        }
        if (other.key() == null ^ this.key() == null) {
            return false;
        }
        if (other.key() != null && !other.key().equals(this.key())) {
            return false;
        }
        if (other.value() == null ^ this.value() == null) {
            return false;
        }
        if (other.value() != null && !other.value().equals(this.value())) {
            return false;
        }
        if (other.propagateAtLaunch() == null ^ this.propagateAtLaunch() == null) {
            return false;
        }
        if (other.propagateAtLaunch() != null && !other.propagateAtLaunch().equals(this.propagateAtLaunch())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (resourceId() != null) {
            sb.append("ResourceId: ").append(resourceId()).append(",");
        }
        if (resourceType() != null) {
            sb.append("ResourceType: ").append(resourceType()).append(",");
        }
        if (key() != null) {
            sb.append("Key: ").append(key()).append(",");
        }
        if (value() != null) {
            sb.append("Value: ").append(value()).append(",");
        }
        if (propagateAtLaunch() != null) {
            sb.append("PropagateAtLaunch: ").append(propagateAtLaunch()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, TagDescription> {
        /**
         * <p>
         * The name of the group.
         * </p>
         * 
         * @param resourceId
         *        The name of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The type of resource. The only supported value is <code>auto-scaling-group</code>.
         * </p>
         * 
         * @param resourceType
         *        The type of resource. The only supported value is <code>auto-scaling-group</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The tag key.
         * </p>
         * 
         * @param key
         *        The tag key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * The tag value.
         * </p>
         * 
         * @param value
         *        The tag value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * Determines whether the tag is added to new instances as they are launched in the group.
         * </p>
         * 
         * @param propagateAtLaunch
         *        Determines whether the tag is added to new instances as they are launched in the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propagateAtLaunch(Boolean propagateAtLaunch);
    }

    private static final class BuilderImpl implements Builder {
        private String resourceId;

        private String resourceType;

        private String key;

        private String value;

        private Boolean propagateAtLaunch;

        private BuilderImpl() {
        }

        private BuilderImpl(TagDescription model) {
            setResourceId(model.resourceId);
            setResourceType(model.resourceType);
            setKey(model.key);
            setValue(model.value);
            setPropagateAtLaunch(model.propagateAtLaunch);
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final Boolean getPropagateAtLaunch() {
            return propagateAtLaunch;
        }

        @Override
        public final Builder propagateAtLaunch(Boolean propagateAtLaunch) {
            this.propagateAtLaunch = propagateAtLaunch;
            return this;
        }

        public final void setPropagateAtLaunch(Boolean propagateAtLaunch) {
            this.propagateAtLaunch = propagateAtLaunch;
        }

        @Override
        public TagDescription build() {
            return new TagDescription(this);
        }
    }
}
