/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class TerminateInstanceInAutoScalingGroupResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<TerminateInstanceInAutoScalingGroupResponse.Builder, TerminateInstanceInAutoScalingGroupResponse> {
    private final Activity activity;

    private TerminateInstanceInAutoScalingGroupResponse(BuilderImpl builder) {
        this.activity = builder.activity;
    }

    /**
     * <p>
     * A scaling activity.
     * </p>
     * 
     * @return A scaling activity.
     */
    public Activity activity() {
        return activity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((activity() == null) ? 0 : activity().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TerminateInstanceInAutoScalingGroupResponse)) {
            return false;
        }
        TerminateInstanceInAutoScalingGroupResponse other = (TerminateInstanceInAutoScalingGroupResponse) obj;
        if (other.activity() == null ^ this.activity() == null) {
            return false;
        }
        if (other.activity() != null && !other.activity().equals(this.activity())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (activity() != null) {
            sb.append("Activity: ").append(activity()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, TerminateInstanceInAutoScalingGroupResponse> {
        /**
         * <p>
         * A scaling activity.
         * </p>
         * 
         * @param activity
         *        A scaling activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activity(Activity activity);
    }

    private static final class BuilderImpl implements Builder {
        private Activity activity;

        private BuilderImpl() {
        }

        private BuilderImpl(TerminateInstanceInAutoScalingGroupResponse model) {
            setActivity(model.activity);
        }

        public final Activity getActivity() {
            return activity;
        }

        @Override
        public final Builder activity(Activity activity) {
            this.activity = activity;
            return this;
        }

        public final void setActivity(Activity activity) {
            this.activity = activity;
        }

        @Override
        public TerminateInstanceInAutoScalingGroupResponse build() {
            return new TerminateInstanceInAutoScalingGroupResponse(this);
        }
    }
}
