/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a block device mapping.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class BlockDeviceMapping implements ToCopyableBuilder<BlockDeviceMapping.Builder, BlockDeviceMapping> {
    private final String virtualName;

    private final String deviceName;

    private final Ebs ebs;

    private final Boolean noDevice;

    private BlockDeviceMapping(BuilderImpl builder) {
        this.virtualName = builder.virtualName;
        this.deviceName = builder.deviceName;
        this.ebs = builder.ebs;
        this.noDevice = builder.noDevice;
    }

    /**
     * <p>
     * The name of the virtual device (for example, <code>ephemeral0</code>).
     * </p>
     * 
     * @return The name of the virtual device (for example, <code>ephemeral0</code>).
     */
    public String virtualName() {
        return virtualName;
    }

    /**
     * <p>
     * The device name exposed to the EC2 instance (for example, <code>/dev/sdh</code> or <code>xvdh</code>).
     * </p>
     * 
     * @return The device name exposed to the EC2 instance (for example, <code>/dev/sdh</code> or <code>xvdh</code>).
     */
    public String deviceName() {
        return deviceName;
    }

    /**
     * <p>
     * The information about the Amazon EBS volume.
     * </p>
     * 
     * @return The information about the Amazon EBS volume.
     */
    public Ebs ebs() {
        return ebs;
    }

    /**
     * <p>
     * Suppresses a device mapping.
     * </p>
     * <p>
     * If this parameter is true for the root device, the instance might fail the EC2 health check. Auto Scaling
     * launches a replacement instance if the instance fails the health check.
     * </p>
     * 
     * @return Suppresses a device mapping.</p>
     *         <p>
     *         If this parameter is true for the root device, the instance might fail the EC2 health check. Auto Scaling
     *         launches a replacement instance if the instance fails the health check.
     */
    public Boolean noDevice() {
        return noDevice;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((virtualName() == null) ? 0 : virtualName().hashCode());
        hashCode = 31 * hashCode + ((deviceName() == null) ? 0 : deviceName().hashCode());
        hashCode = 31 * hashCode + ((ebs() == null) ? 0 : ebs().hashCode());
        hashCode = 31 * hashCode + ((noDevice() == null) ? 0 : noDevice().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlockDeviceMapping)) {
            return false;
        }
        BlockDeviceMapping other = (BlockDeviceMapping) obj;
        if (other.virtualName() == null ^ this.virtualName() == null) {
            return false;
        }
        if (other.virtualName() != null && !other.virtualName().equals(this.virtualName())) {
            return false;
        }
        if (other.deviceName() == null ^ this.deviceName() == null) {
            return false;
        }
        if (other.deviceName() != null && !other.deviceName().equals(this.deviceName())) {
            return false;
        }
        if (other.ebs() == null ^ this.ebs() == null) {
            return false;
        }
        if (other.ebs() != null && !other.ebs().equals(this.ebs())) {
            return false;
        }
        if (other.noDevice() == null ^ this.noDevice() == null) {
            return false;
        }
        if (other.noDevice() != null && !other.noDevice().equals(this.noDevice())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (virtualName() != null) {
            sb.append("VirtualName: ").append(virtualName()).append(",");
        }
        if (deviceName() != null) {
            sb.append("DeviceName: ").append(deviceName()).append(",");
        }
        if (ebs() != null) {
            sb.append("Ebs: ").append(ebs()).append(",");
        }
        if (noDevice() != null) {
            sb.append("NoDevice: ").append(noDevice()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, BlockDeviceMapping> {
        /**
         * <p>
         * The name of the virtual device (for example, <code>ephemeral0</code>).
         * </p>
         * 
         * @param virtualName
         *        The name of the virtual device (for example, <code>ephemeral0</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualName(String virtualName);

        /**
         * <p>
         * The device name exposed to the EC2 instance (for example, <code>/dev/sdh</code> or <code>xvdh</code>).
         * </p>
         * 
         * @param deviceName
         *        The device name exposed to the EC2 instance (for example, <code>/dev/sdh</code> or <code>xvdh</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceName(String deviceName);

        /**
         * <p>
         * The information about the Amazon EBS volume.
         * </p>
         * 
         * @param ebs
         *        The information about the Amazon EBS volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebs(Ebs ebs);

        /**
         * <p>
         * Suppresses a device mapping.
         * </p>
         * <p>
         * If this parameter is true for the root device, the instance might fail the EC2 health check. Auto Scaling
         * launches a replacement instance if the instance fails the health check.
         * </p>
         * 
         * @param noDevice
         *        Suppresses a device mapping.</p>
         *        <p>
         *        If this parameter is true for the root device, the instance might fail the EC2 health check. Auto
         *        Scaling launches a replacement instance if the instance fails the health check.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noDevice(Boolean noDevice);
    }

    private static final class BuilderImpl implements Builder {
        private String virtualName;

        private String deviceName;

        private Ebs ebs;

        private Boolean noDevice;

        private BuilderImpl() {
        }

        private BuilderImpl(BlockDeviceMapping model) {
            setVirtualName(model.virtualName);
            setDeviceName(model.deviceName);
            setEbs(model.ebs);
            setNoDevice(model.noDevice);
        }

        public final String getVirtualName() {
            return virtualName;
        }

        @Override
        public final Builder virtualName(String virtualName) {
            this.virtualName = virtualName;
            return this;
        }

        public final void setVirtualName(String virtualName) {
            this.virtualName = virtualName;
        }

        public final String getDeviceName() {
            return deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public final Ebs getEbs() {
            return ebs;
        }

        @Override
        public final Builder ebs(Ebs ebs) {
            this.ebs = ebs;
            return this;
        }

        public final void setEbs(Ebs ebs) {
            this.ebs = ebs;
        }

        public final Boolean getNoDevice() {
            return noDevice;
        }

        @Override
        public final Builder noDevice(Boolean noDevice) {
            this.noDevice = noDevice;
            return this;
        }

        public final void setNoDevice(Boolean noDevice) {
            this.noDevice = noDevice;
        }

        @Override
        public BlockDeviceMapping build() {
            return new BlockDeviceMapping(this);
        }
    }
}
