/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeLaunchConfigurationsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeLaunchConfigurationsResponse.Builder, DescribeLaunchConfigurationsResponse> {
    private final List<LaunchConfiguration> launchConfigurations;

    private final String nextToken;

    private DescribeLaunchConfigurationsResponse(BuilderImpl builder) {
        this.launchConfigurations = builder.launchConfigurations;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The launch configurations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The launch configurations.
     */
    public List<LaunchConfiguration> launchConfigurations() {
        return launchConfigurations;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((launchConfigurations() == null) ? 0 : launchConfigurations().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLaunchConfigurationsResponse)) {
            return false;
        }
        DescribeLaunchConfigurationsResponse other = (DescribeLaunchConfigurationsResponse) obj;
        if (other.launchConfigurations() == null ^ this.launchConfigurations() == null) {
            return false;
        }
        if (other.launchConfigurations() != null && !other.launchConfigurations().equals(this.launchConfigurations())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (launchConfigurations() != null) {
            sb.append("LaunchConfigurations: ").append(launchConfigurations()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeLaunchConfigurationsResponse> {
        /**
         * <p>
         * The launch configurations.
         * </p>
         * 
         * @param launchConfigurations
         *        The launch configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchConfigurations(Collection<LaunchConfiguration> launchConfigurations);

        /**
         * <p>
         * The launch configurations.
         * </p>
         * 
         * @param launchConfigurations
         *        The launch configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchConfigurations(LaunchConfiguration... launchConfigurations);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<LaunchConfiguration> launchConfigurations;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLaunchConfigurationsResponse model) {
            setLaunchConfigurations(model.launchConfigurations);
            setNextToken(model.nextToken);
        }

        public final Collection<LaunchConfiguration> getLaunchConfigurations() {
            return launchConfigurations;
        }

        @Override
        public final Builder launchConfigurations(Collection<LaunchConfiguration> launchConfigurations) {
            this.launchConfigurations = LaunchConfigurationsCopier.copy(launchConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchConfigurations(LaunchConfiguration... launchConfigurations) {
            launchConfigurations(Arrays.asList(launchConfigurations));
            return this;
        }

        public final void setLaunchConfigurations(Collection<LaunchConfiguration> launchConfigurations) {
            this.launchConfigurations = LaunchConfigurationsCopier.copy(launchConfigurations);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeLaunchConfigurationsResponse build() {
            return new DescribeLaunchConfigurationsResponse(this);
        }
    }
}
