/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class PutScalingPolicyResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<PutScalingPolicyResponse.Builder, PutScalingPolicyResponse> {
    private final String policyARN;

    private PutScalingPolicyResponse(BuilderImpl builder) {
        this.policyARN = builder.policyARN;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the policy.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the policy.
     */
    public String policyARN() {
        return policyARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((policyARN() == null) ? 0 : policyARN().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutScalingPolicyResponse)) {
            return false;
        }
        PutScalingPolicyResponse other = (PutScalingPolicyResponse) obj;
        if (other.policyARN() == null ^ this.policyARN() == null) {
            return false;
        }
        if (other.policyARN() != null && !other.policyARN().equals(this.policyARN())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (policyARN() != null) {
            sb.append("PolicyARN: ").append(policyARN()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, PutScalingPolicyResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the policy.
         * </p>
         * 
         * @param policyARN
         *        The Amazon Resource Name (ARN) of the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyARN(String policyARN);
    }

    private static final class BuilderImpl implements Builder {
        private String policyARN;

        private BuilderImpl() {
        }

        private BuilderImpl(PutScalingPolicyResponse model) {
            setPolicyARN(model.policyARN);
        }

        public final String getPolicyARN() {
            return policyARN;
        }

        @Override
        public final Builder policyARN(String policyARN) {
            this.policyARN = policyARN;
            return this;
        }

        public final void setPolicyARN(String policyARN) {
            this.policyARN = policyARN;
        }

        @Override
        public PutScalingPolicyResponse build() {
            return new PutScalingPolicyResponse(this);
        }
    }
}
