/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsRequest;
import software.amazon.awssdk.util.StringUtils;

public class DescribeAutoScalingGroupsRequestMarshaller
implements Marshaller<Request<DescribeAutoScalingGroupsRequest>, DescribeAutoScalingGroupsRequest> {
    public Request<DescribeAutoScalingGroupsRequest> marshall(DescribeAutoScalingGroupsRequest describeAutoScalingGroupsRequest) {
        if (describeAutoScalingGroupsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeAutoScalingGroupsRequest, "AutoScalingClient");
        request.addParameter("Action", "DescribeAutoScalingGroups");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> autoScalingGroupNamesList = describeAutoScalingGroupsRequest.autoScalingGroupNames();
        if (autoScalingGroupNamesList != null) {
            if (!autoScalingGroupNamesList.isEmpty()) {
                int autoScalingGroupNamesListIndex = 1;
                for (String autoScalingGroupNamesListValue : autoScalingGroupNamesList) {
                    if (autoScalingGroupNamesListValue != null) {
                        request.addParameter("AutoScalingGroupNames.member." + autoScalingGroupNamesListIndex, StringUtils.fromString((String)autoScalingGroupNamesListValue));
                    }
                    ++autoScalingGroupNamesListIndex;
                }
            } else {
                request.addParameter("AutoScalingGroupNames", "");
            }
        }
        if (describeAutoScalingGroupsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeAutoScalingGroupsRequest.nextToken()));
        }
        if (describeAutoScalingGroupsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeAutoScalingGroupsRequest.maxRecords()));
        }
        return request;
    }
}

