/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeLifecycleHookTypesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeLifecycleHookTypesResponse.Builder, DescribeLifecycleHookTypesResponse> {
    private final List<String> lifecycleHookTypes;

    private DescribeLifecycleHookTypesResponse(BuilderImpl builder) {
        this.lifecycleHookTypes = builder.lifecycleHookTypes;
    }

    /**
     * <p>
     * The lifecycle hook types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The lifecycle hook types.
     */
    public List<String> lifecycleHookTypes() {
        return lifecycleHookTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((lifecycleHookTypes() == null) ? 0 : lifecycleHookTypes().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLifecycleHookTypesResponse)) {
            return false;
        }
        DescribeLifecycleHookTypesResponse other = (DescribeLifecycleHookTypesResponse) obj;
        if (other.lifecycleHookTypes() == null ^ this.lifecycleHookTypes() == null) {
            return false;
        }
        if (other.lifecycleHookTypes() != null && !other.lifecycleHookTypes().equals(this.lifecycleHookTypes())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (lifecycleHookTypes() != null) {
            sb.append("LifecycleHookTypes: ").append(lifecycleHookTypes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeLifecycleHookTypesResponse> {
        /**
         * <p>
         * The lifecycle hook types.
         * </p>
         * 
         * @param lifecycleHookTypes
         *        The lifecycle hook types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleHookTypes(Collection<String> lifecycleHookTypes);

        /**
         * <p>
         * The lifecycle hook types.
         * </p>
         * 
         * @param lifecycleHookTypes
         *        The lifecycle hook types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleHookTypes(String... lifecycleHookTypes);
    }

    private static final class BuilderImpl implements Builder {
        private List<String> lifecycleHookTypes;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLifecycleHookTypesResponse model) {
            setLifecycleHookTypes(model.lifecycleHookTypes);
        }

        public final Collection<String> getLifecycleHookTypes() {
            return lifecycleHookTypes;
        }

        @Override
        public final Builder lifecycleHookTypes(Collection<String> lifecycleHookTypes) {
            this.lifecycleHookTypes = AutoScalingNotificationTypesCopier.copy(lifecycleHookTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecycleHookTypes(String... lifecycleHookTypes) {
            lifecycleHookTypes(Arrays.asList(lifecycleHookTypes));
            return this;
        }

        public final void setLifecycleHookTypes(Collection<String> lifecycleHookTypes) {
            this.lifecycleHookTypes = AutoScalingNotificationTypesCopier.copy(lifecycleHookTypes);
        }

        @Override
        public DescribeLifecycleHookTypesResponse build() {
            return new DescribeLifecycleHookTypesResponse(this);
        }
    }
}
