/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.autoscaling.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.util.StringUtils;

/**
 * DeleteTagsRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DeleteTagsRequestMarshaller implements Marshaller<Request<DeleteTagsRequest>, DeleteTagsRequest> {

    public Request<DeleteTagsRequest> marshall(DeleteTagsRequest deleteTagsRequest) {

        if (deleteTagsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<DeleteTagsRequest> request = new DefaultRequest<DeleteTagsRequest>(deleteTagsRequest, "AutoScalingClient");
        request.addParameter("Action", "DeleteTags");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);

        java.util.List<Tag> tagsList = deleteTagsRequest.tags();

        if (tagsList != null) {
            if (!tagsList.isEmpty()) {
                int tagsListIndex = 1;

                for (Tag tagsListValue : tagsList) {

                    if (tagsListValue.resourceId() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".ResourceId",
                                StringUtils.fromString(tagsListValue.resourceId()));
                    }

                    if (tagsListValue.resourceType() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".ResourceType",
                                StringUtils.fromString(tagsListValue.resourceType()));
                    }

                    if (tagsListValue.key() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Key", StringUtils.fromString(tagsListValue.key()));
                    }

                    if (tagsListValue.value() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".Value",
                                StringUtils.fromString(tagsListValue.value()));
                    }

                    if (tagsListValue.propagateAtLaunch() != null) {
                        request.addParameter("Tags.member." + tagsListIndex + ".PropagateAtLaunch",
                                StringUtils.fromBoolean(tagsListValue.propagateAtLaunch()));
                    }
                    tagsListIndex++;
                }
            } else {
                request.addParameter("Tags", "");
            }
        }

        return request;
    }

}
