/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.autoscaling.model.LoadBalancerState;
import software.amazon.awssdk.services.autoscaling.model.LoadBalancerStatesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeLoadBalancersResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeLoadBalancersResponse> {
    private final List<LoadBalancerState> loadBalancers;
    private final String nextToken;

    private DescribeLoadBalancersResponse(BuilderImpl builder) {
        this.loadBalancers = builder.loadBalancers;
        this.nextToken = builder.nextToken;
    }

    public List<LoadBalancerState> loadBalancers() {
        return this.loadBalancers;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.loadBalancers() == null ? 0 : this.loadBalancers().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLoadBalancersResponse)) {
            return false;
        }
        DescribeLoadBalancersResponse other = (DescribeLoadBalancersResponse)((Object)obj);
        if (other.loadBalancers() == null ^ this.loadBalancers() == null) {
            return false;
        }
        if (other.loadBalancers() != null && !other.loadBalancers().equals(this.loadBalancers())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.loadBalancers() != null) {
            sb.append("LoadBalancers: ").append(this.loadBalancers()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<LoadBalancerState> loadBalancers;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLoadBalancersResponse model) {
            this.setLoadBalancers(model.loadBalancers);
            this.setNextToken(model.nextToken);
        }

        public final Collection<LoadBalancerState> getLoadBalancers() {
            return this.loadBalancers;
        }

        @Override
        public final Builder loadBalancers(Collection<LoadBalancerState> loadBalancers) {
            this.loadBalancers = LoadBalancerStatesCopier.copy(loadBalancers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancers(LoadBalancerState ... loadBalancers) {
            this.loadBalancers(Arrays.asList(loadBalancers));
            return this;
        }

        public final void setLoadBalancers(Collection<LoadBalancerState> loadBalancers) {
            this.loadBalancers = LoadBalancerStatesCopier.copy(loadBalancers);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeLoadBalancersResponse build() {
            return new DescribeLoadBalancersResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeLoadBalancersResponse> {
        public Builder loadBalancers(Collection<LoadBalancerState> var1);

        public Builder loadBalancers(LoadBalancerState ... var1);

        public Builder nextToken(String var1);
    }
}

