/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.autoscaling.model.NotificationConfiguration;
import software.amazon.awssdk.services.autoscaling.model.NotificationConfigurationsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeNotificationConfigurationsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeNotificationConfigurationsResponse> {
    private final List<NotificationConfiguration> notificationConfigurations;
    private final String nextToken;

    private DescribeNotificationConfigurationsResponse(BuilderImpl builder) {
        this.notificationConfigurations = builder.notificationConfigurations;
        this.nextToken = builder.nextToken;
    }

    public List<NotificationConfiguration> notificationConfigurations() {
        return this.notificationConfigurations;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.notificationConfigurations() == null ? 0 : this.notificationConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNotificationConfigurationsResponse)) {
            return false;
        }
        DescribeNotificationConfigurationsResponse other = (DescribeNotificationConfigurationsResponse)((Object)obj);
        if (other.notificationConfigurations() == null ^ this.notificationConfigurations() == null) {
            return false;
        }
        if (other.notificationConfigurations() != null && !other.notificationConfigurations().equals(this.notificationConfigurations())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.notificationConfigurations() != null) {
            sb.append("NotificationConfigurations: ").append(this.notificationConfigurations()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<NotificationConfiguration> notificationConfigurations;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNotificationConfigurationsResponse model) {
            this.setNotificationConfigurations(model.notificationConfigurations);
            this.setNextToken(model.nextToken);
        }

        public final Collection<NotificationConfiguration> getNotificationConfigurations() {
            return this.notificationConfigurations;
        }

        @Override
        public final Builder notificationConfigurations(Collection<NotificationConfiguration> notificationConfigurations) {
            this.notificationConfigurations = NotificationConfigurationsCopier.copy(notificationConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationConfigurations(NotificationConfiguration ... notificationConfigurations) {
            this.notificationConfigurations(Arrays.asList(notificationConfigurations));
            return this;
        }

        public final void setNotificationConfigurations(Collection<NotificationConfiguration> notificationConfigurations) {
            this.notificationConfigurations = NotificationConfigurationsCopier.copy(notificationConfigurations);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeNotificationConfigurationsResponse build() {
            return new DescribeNotificationConfigurationsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeNotificationConfigurationsResponse> {
        public Builder notificationConfigurations(Collection<NotificationConfiguration> var1);

        public Builder notificationConfigurations(NotificationConfiguration ... var1);

        public Builder nextToken(String var1);
    }
}

