/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.autoscaling.model.SetInstanceHealthRequest;
import software.amazon.awssdk.util.StringUtils;

public class SetInstanceHealthRequestMarshaller
implements Marshaller<Request<SetInstanceHealthRequest>, SetInstanceHealthRequest> {
    public Request<SetInstanceHealthRequest> marshall(SetInstanceHealthRequest setInstanceHealthRequest) {
        if (setInstanceHealthRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)setInstanceHealthRequest, "AutoScalingClient");
        request.addParameter("Action", "SetInstanceHealth");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (setInstanceHealthRequest.instanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString((String)setInstanceHealthRequest.instanceId()));
        }
        if (setInstanceHealthRequest.healthStatus() != null) {
            request.addParameter("HealthStatus", StringUtils.fromString((String)setInstanceHealthRequest.healthStatus()));
        }
        if (setInstanceHealthRequest.shouldRespectGracePeriod() != null) {
            request.addParameter("ShouldRespectGracePeriod", StringUtils.fromBoolean((Boolean)setInstanceHealthRequest.shouldRespectGracePeriod()));
        }
        return request;
    }
}

