/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeAccountLimitsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeAccountLimitsResponse.Builder, DescribeAccountLimitsResponse> {
    private final Integer maxNumberOfAutoScalingGroups;

    private final Integer maxNumberOfLaunchConfigurations;

    private final Integer numberOfAutoScalingGroups;

    private final Integer numberOfLaunchConfigurations;

    private DescribeAccountLimitsResponse(BuilderImpl builder) {
        this.maxNumberOfAutoScalingGroups = builder.maxNumberOfAutoScalingGroups;
        this.maxNumberOfLaunchConfigurations = builder.maxNumberOfLaunchConfigurations;
        this.numberOfAutoScalingGroups = builder.numberOfAutoScalingGroups;
        this.numberOfLaunchConfigurations = builder.numberOfLaunchConfigurations;
    }

    /**
     * <p>
     * The maximum number of groups allowed for your AWS account. The default limit is 20 per region.
     * </p>
     * 
     * @return The maximum number of groups allowed for your AWS account. The default limit is 20 per region.
     */
    public Integer maxNumberOfAutoScalingGroups() {
        return maxNumberOfAutoScalingGroups;
    }

    /**
     * <p>
     * The maximum number of launch configurations allowed for your AWS account. The default limit is 100 per region.
     * </p>
     * 
     * @return The maximum number of launch configurations allowed for your AWS account. The default limit is 100 per
     *         region.
     */
    public Integer maxNumberOfLaunchConfigurations() {
        return maxNumberOfLaunchConfigurations;
    }

    /**
     * <p>
     * The current number of groups for your AWS account.
     * </p>
     * 
     * @return The current number of groups for your AWS account.
     */
    public Integer numberOfAutoScalingGroups() {
        return numberOfAutoScalingGroups;
    }

    /**
     * <p>
     * The current number of launch configurations for your AWS account.
     * </p>
     * 
     * @return The current number of launch configurations for your AWS account.
     */
    public Integer numberOfLaunchConfigurations() {
        return numberOfLaunchConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((maxNumberOfAutoScalingGroups() == null) ? 0 : maxNumberOfAutoScalingGroups().hashCode());
        hashCode = 31 * hashCode
                + ((maxNumberOfLaunchConfigurations() == null) ? 0 : maxNumberOfLaunchConfigurations().hashCode());
        hashCode = 31 * hashCode + ((numberOfAutoScalingGroups() == null) ? 0 : numberOfAutoScalingGroups().hashCode());
        hashCode = 31 * hashCode + ((numberOfLaunchConfigurations() == null) ? 0 : numberOfLaunchConfigurations().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccountLimitsResponse)) {
            return false;
        }
        DescribeAccountLimitsResponse other = (DescribeAccountLimitsResponse) obj;
        if (other.maxNumberOfAutoScalingGroups() == null ^ this.maxNumberOfAutoScalingGroups() == null) {
            return false;
        }
        if (other.maxNumberOfAutoScalingGroups() != null
                && !other.maxNumberOfAutoScalingGroups().equals(this.maxNumberOfAutoScalingGroups())) {
            return false;
        }
        if (other.maxNumberOfLaunchConfigurations() == null ^ this.maxNumberOfLaunchConfigurations() == null) {
            return false;
        }
        if (other.maxNumberOfLaunchConfigurations() != null
                && !other.maxNumberOfLaunchConfigurations().equals(this.maxNumberOfLaunchConfigurations())) {
            return false;
        }
        if (other.numberOfAutoScalingGroups() == null ^ this.numberOfAutoScalingGroups() == null) {
            return false;
        }
        if (other.numberOfAutoScalingGroups() != null
                && !other.numberOfAutoScalingGroups().equals(this.numberOfAutoScalingGroups())) {
            return false;
        }
        if (other.numberOfLaunchConfigurations() == null ^ this.numberOfLaunchConfigurations() == null) {
            return false;
        }
        if (other.numberOfLaunchConfigurations() != null
                && !other.numberOfLaunchConfigurations().equals(this.numberOfLaunchConfigurations())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (maxNumberOfAutoScalingGroups() != null) {
            sb.append("MaxNumberOfAutoScalingGroups: ").append(maxNumberOfAutoScalingGroups()).append(",");
        }
        if (maxNumberOfLaunchConfigurations() != null) {
            sb.append("MaxNumberOfLaunchConfigurations: ").append(maxNumberOfLaunchConfigurations()).append(",");
        }
        if (numberOfAutoScalingGroups() != null) {
            sb.append("NumberOfAutoScalingGroups: ").append(numberOfAutoScalingGroups()).append(",");
        }
        if (numberOfLaunchConfigurations() != null) {
            sb.append("NumberOfLaunchConfigurations: ").append(numberOfLaunchConfigurations()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxNumberOfAutoScalingGroups":
            return Optional.of(clazz.cast(maxNumberOfAutoScalingGroups()));
        case "MaxNumberOfLaunchConfigurations":
            return Optional.of(clazz.cast(maxNumberOfLaunchConfigurations()));
        case "NumberOfAutoScalingGroups":
            return Optional.of(clazz.cast(numberOfAutoScalingGroups()));
        case "NumberOfLaunchConfigurations":
            return Optional.of(clazz.cast(numberOfLaunchConfigurations()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeAccountLimitsResponse> {
        /**
         * <p>
         * The maximum number of groups allowed for your AWS account. The default limit is 20 per region.
         * </p>
         * 
         * @param maxNumberOfAutoScalingGroups
         *        The maximum number of groups allowed for your AWS account. The default limit is 20 per region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxNumberOfAutoScalingGroups(Integer maxNumberOfAutoScalingGroups);

        /**
         * <p>
         * The maximum number of launch configurations allowed for your AWS account. The default limit is 100 per
         * region.
         * </p>
         * 
         * @param maxNumberOfLaunchConfigurations
         *        The maximum number of launch configurations allowed for your AWS account. The default limit is 100 per
         *        region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxNumberOfLaunchConfigurations(Integer maxNumberOfLaunchConfigurations);

        /**
         * <p>
         * The current number of groups for your AWS account.
         * </p>
         * 
         * @param numberOfAutoScalingGroups
         *        The current number of groups for your AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfAutoScalingGroups(Integer numberOfAutoScalingGroups);

        /**
         * <p>
         * The current number of launch configurations for your AWS account.
         * </p>
         * 
         * @param numberOfLaunchConfigurations
         *        The current number of launch configurations for your AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfLaunchConfigurations(Integer numberOfLaunchConfigurations);
    }

    static final class BuilderImpl implements Builder {
        private Integer maxNumberOfAutoScalingGroups;

        private Integer maxNumberOfLaunchConfigurations;

        private Integer numberOfAutoScalingGroups;

        private Integer numberOfLaunchConfigurations;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccountLimitsResponse model) {
            maxNumberOfAutoScalingGroups(model.maxNumberOfAutoScalingGroups);
            maxNumberOfLaunchConfigurations(model.maxNumberOfLaunchConfigurations);
            numberOfAutoScalingGroups(model.numberOfAutoScalingGroups);
            numberOfLaunchConfigurations(model.numberOfLaunchConfigurations);
        }

        public final Integer getMaxNumberOfAutoScalingGroups() {
            return maxNumberOfAutoScalingGroups;
        }

        @Override
        public final Builder maxNumberOfAutoScalingGroups(Integer maxNumberOfAutoScalingGroups) {
            this.maxNumberOfAutoScalingGroups = maxNumberOfAutoScalingGroups;
            return this;
        }

        public final void setMaxNumberOfAutoScalingGroups(Integer maxNumberOfAutoScalingGroups) {
            this.maxNumberOfAutoScalingGroups = maxNumberOfAutoScalingGroups;
        }

        public final Integer getMaxNumberOfLaunchConfigurations() {
            return maxNumberOfLaunchConfigurations;
        }

        @Override
        public final Builder maxNumberOfLaunchConfigurations(Integer maxNumberOfLaunchConfigurations) {
            this.maxNumberOfLaunchConfigurations = maxNumberOfLaunchConfigurations;
            return this;
        }

        public final void setMaxNumberOfLaunchConfigurations(Integer maxNumberOfLaunchConfigurations) {
            this.maxNumberOfLaunchConfigurations = maxNumberOfLaunchConfigurations;
        }

        public final Integer getNumberOfAutoScalingGroups() {
            return numberOfAutoScalingGroups;
        }

        @Override
        public final Builder numberOfAutoScalingGroups(Integer numberOfAutoScalingGroups) {
            this.numberOfAutoScalingGroups = numberOfAutoScalingGroups;
            return this;
        }

        public final void setNumberOfAutoScalingGroups(Integer numberOfAutoScalingGroups) {
            this.numberOfAutoScalingGroups = numberOfAutoScalingGroups;
        }

        public final Integer getNumberOfLaunchConfigurations() {
            return numberOfLaunchConfigurations;
        }

        @Override
        public final Builder numberOfLaunchConfigurations(Integer numberOfLaunchConfigurations) {
            this.numberOfLaunchConfigurations = numberOfLaunchConfigurations;
            return this;
        }

        public final void setNumberOfLaunchConfigurations(Integer numberOfLaunchConfigurations) {
            this.numberOfLaunchConfigurations = numberOfLaunchConfigurations;
        }

        @Override
        public DescribeAccountLimitsResponse build() {
            return new DescribeAccountLimitsResponse(this);
        }
    }
}
