/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeAutoScalingInstancesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeAutoScalingInstancesResponse.Builder, DescribeAutoScalingInstancesResponse> {
    private final List<AutoScalingInstanceDetails> autoScalingInstances;

    private final String nextToken;

    private DescribeAutoScalingInstancesResponse(BuilderImpl builder) {
        this.autoScalingInstances = builder.autoScalingInstances;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The instances.
     */
    public List<AutoScalingInstanceDetails> autoScalingInstances() {
        return autoScalingInstances;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((autoScalingInstances() == null) ? 0 : autoScalingInstances().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAutoScalingInstancesResponse)) {
            return false;
        }
        DescribeAutoScalingInstancesResponse other = (DescribeAutoScalingInstancesResponse) obj;
        if (other.autoScalingInstances() == null ^ this.autoScalingInstances() == null) {
            return false;
        }
        if (other.autoScalingInstances() != null && !other.autoScalingInstances().equals(this.autoScalingInstances())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (autoScalingInstances() != null) {
            sb.append("AutoScalingInstances: ").append(autoScalingInstances()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoScalingInstances":
            return Optional.of(clazz.cast(autoScalingInstances()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeAutoScalingInstancesResponse> {
        /**
         * <p>
         * The instances.
         * </p>
         * 
         * @param autoScalingInstances
         *        The instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingInstances(Collection<AutoScalingInstanceDetails> autoScalingInstances);

        /**
         * <p>
         * The instances.
         * </p>
         * 
         * @param autoScalingInstances
         *        The instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingInstances(AutoScalingInstanceDetails... autoScalingInstances);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl implements Builder {
        private List<AutoScalingInstanceDetails> autoScalingInstances;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAutoScalingInstancesResponse model) {
            autoScalingInstances(model.autoScalingInstances);
            nextToken(model.nextToken);
        }

        public final Collection<AutoScalingInstanceDetails.Builder> getAutoScalingInstances() {
            return autoScalingInstances != null ? autoScalingInstances.stream().map(AutoScalingInstanceDetails::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder autoScalingInstances(Collection<AutoScalingInstanceDetails> autoScalingInstances) {
            this.autoScalingInstances = AutoScalingInstancesCopier.copy(autoScalingInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoScalingInstances(AutoScalingInstanceDetails... autoScalingInstances) {
            autoScalingInstances(Arrays.asList(autoScalingInstances));
            return this;
        }

        public final void setAutoScalingInstances(Collection<AutoScalingInstanceDetails.BuilderImpl> autoScalingInstances) {
            this.autoScalingInstances = AutoScalingInstancesCopier.copyFromBuilder(autoScalingInstances);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeAutoScalingInstancesResponse build() {
            return new DescribeAutoScalingInstancesResponse(this);
        }
    }
}
